/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.logger;

import net.sf.jkniv.logger.FormatterLogger;
import net.sf.jkniv.sqlegance.logger.DataMasking;
import net.sf.jkniv.sqlegance.logger.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlLogger {
    private static final Logger LOG = LoggerFactory.getLogger((String)"net.sf.jkniv.sqlegance.SQL");
    private static final FormatterLogger formatter = new FormatterLogger();
    private LogLevel logLevel;
    private DataMasking masking;

    public SqlLogger(LogLevel logLevel, DataMasking masking) {
        this.logLevel = logLevel;
        this.masking = masking;
    }

    public Object mask(String attributeName, Object data) {
        return this.masking.mask(attributeName, data);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void log(String format, Object ... args) {
        this.log(LogLevel.RESULTSET, format, args);
    }

    public void log(LogLevel level, String format, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(format, args);
        } else if (level.ordinal() <= this.logLevel.ordinal() && this.logLevel != LogLevel.NONE) {
            System.out.printf("[" + Thread.currentThread().getName() + "] " + "[" + (Object)((Object)this.logLevel) + "] " + formatter.formatterSlf4j(format) + "\n", formatter.toString(args));
        }
    }

    public boolean isEnabled(LogLevel level) {
        return LOG.isDebugEnabled() || level.ordinal() <= this.logLevel.ordinal() && this.logLevel != LogLevel.NONE;
    }
}

