/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.jkniv.sqlegance.DefaultClassLoader;
import net.sf.jkniv.sqlegance.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class XmlValidator {
    private static final Logger LOG = LoggerFactory.getLogger(XmlValidator.class);

    XmlValidator() {
    }

    public static void validate(URL[] schemaFiles, String resourceName) {
        StreamSource xmlFile = null;
        try {
            try {
                xmlFile = new StreamSource(DefaultClassLoader.getResourceAsStream(resourceName));
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource source1 = new StreamSource(schemaFiles[0].toExternalForm());
                StreamSource source2 = new StreamSource(schemaFiles[1].toExternalForm());
                Schema schema = null;
                schema = resourceName.endsWith("repository-config.xml") ? schemaFactory.newSchema(new Source[]{source1}) : schemaFactory.newSchema(new Source[]{source1, source2});
                Validator validator = schema.newValidator();
                xmlFile.setSystemId(resourceName);
                validator.validate(xmlFile);
            }
            catch (SAXException e) {
                List<URL> schemas = Arrays.asList(schemaFiles);
                throw new RepositoryException("Fail validate [" + resourceName + "] against XSD=[" + schemas + "]. " + e.getMessage(), e);
            }
            catch (IOException e) {
                List<URL> schemas = Arrays.asList(schemaFiles);
                throw new RepositoryException("Fail validate [" + resourceName + "] against XSD=[" + schemas + "]. " + e.getMessage(), e);
            }
        }
        finally {
            if (xmlFile != null) {
                XmlValidator.closeStream(xmlFile.getInputStream(), resourceName);
            }
        }
    }

    private static void closeStream(InputStream is, String resourceName) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.warn("Cannot close input stream [{}]", (Object)resourceName);
            }
        }
    }
}

