/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import net.sf.jkniv.sqlegance.Insertable;
import net.sf.jkniv.sqlegance.LanguageType;
import net.sf.jkniv.sqlegance.RepositoryException;
import net.sf.jkniv.sqlegance.Selectable;
import net.sf.jkniv.sqlegance.Sql;
import net.sf.jkniv.sqlegance.Statistical;
import net.sf.jkniv.sqlegance.builder.RepositoryConfig;
import net.sf.jkniv.sqlegance.builder.XmlReader;
import net.sf.jkniv.sqlegance.builder.xml.AutoGeneratedKey;
import net.sf.jkniv.sqlegance.builder.xml.OneToManyTag;
import net.sf.jkniv.sqlegance.builder.xml.ProcedureParameterTag;
import net.sf.jkniv.sqlegance.builder.xml.ProcedureTag;
import net.sf.jkniv.sqlegance.builder.xml.SqlTag;
import net.sf.jkniv.sqlegance.builder.xml.TagFactory;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ChooseTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.IfTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.OtherwiseTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.SetTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.StaticText;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.WhenTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.WhereTag;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import net.sf.jkniv.sqlegance.statement.ResultSetConcurrency;
import net.sf.jkniv.sqlegance.statement.ResultSetHoldability;
import net.sf.jkniv.sqlegance.statement.ResultSetType;
import net.sf.jkniv.sqlegance.transaction.Isolation;
import net.sf.jkniv.sqlegance.validation.ValidateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XmlStatement {
    private static final Logger LOG = LoggerFactory.getLogger(XmlStatement.class);
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    static final String ROOT_NODE = "statements";
    private static final String ROOT_NODE_PACKAGE = "statements/package";
    private static final String NODE_PACKAGE_BYNAME = "statements/package[@name='%s']/";
    static final String ATTR_CONTEXT_NAME = "context";
    static final String SCHEMA_XSD = "/net/sf/jkniv/sqlegance/builder/xml/sqlegance-stmt.xsd";
    private String resourceName;
    private Date timestamp;
    private String contextName;
    private XmlReader xmlReader;

    public XmlStatement(String resourceName) {
        this.resourceName = resourceName;
    }

    public void load() {
        this.xmlReader = new XmlReader(this.resourceName);
        this.xmlReader.load();
    }

    public Map<String, Sql> build(RepositoryConfig repositoryConfig) {
        this.timestamp = new Date();
        HashMap<String, Sql> statements = new HashMap<String, Sql>();
        this.processTagsElements("statements/select", "", statements, repositoryConfig);
        this.processTagsElements("statements/insert", "", statements, repositoryConfig);
        this.processTagsElements("statements/update", "", statements, repositoryConfig);
        this.processTagsElements("statements/delete", "", statements, repositoryConfig);
        this.processProcedureElements("statements/procedure", "", statements, repositoryConfig);
        NodeList nodes = this.xmlReader.evaluateXpath(ROOT_NODE_PACKAGE);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    this.processTagsElements("statements/package[@name='%s']/select", name, statements, repositoryConfig);
                    this.processTagsElements("statements/package[@name='%s']/insert", name, statements, repositoryConfig);
                    this.processTagsElements("statements/package[@name='%s']/update", name, statements, repositoryConfig);
                    this.processTagsElements("statements/package[@name='%s']/delete", name, statements, repositoryConfig);
                    this.processProcedureElements("statements/package[@name='%s']/procedure", name, statements, repositoryConfig);
                }
                ++i;
            }
        }
        return statements;
    }

    public NodeList evaluateXpath(String expressionXpath) {
        return this.xmlReader.evaluateXpath(expressionXpath, true);
    }

    public Element getFirstElement(String expressionXpath) {
        return this.xmlReader.getFirstElement(expressionXpath);
    }

    private void processTagsElements(String expressionXpath, String packet, Map<String, Sql> statements, RepositoryConfig repositoryConfig) {
        SqlDialect sqlDialect = repositoryConfig.getSqlDialect();
        String xpathSql = String.format(expressionXpath, packet);
        NodeList nodes = this.xmlReader.evaluateXpath(xpathSql);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    SqlTag tag = this.buildSql(element, node.getNodeName(), xpathSql, repositoryConfig.getStatistical());
                    tag.bind(sqlDialect);
                    Sql oldSql = this.put(packet, statements, tag);
                    if (oldSql != null) {
                        LOG.info("SQL {} was updated", (Object)oldSql.getName());
                    }
                }
                ++i;
            }
        }
    }

    private SqlTag buildSql(Element element, String nodeName, String xpathSql, Statistical stats) {
        SqlTag tag = null;
        if ("procedure".equals(nodeName)) {
            tag = this.buildProcedure(element, xpathSql, stats);
        } else {
            String id = element.getAttribute("id");
            LanguageType type = LanguageType.get(element.getAttribute("type"));
            Isolation isolation = Isolation.get(element.getAttribute("isolation"));
            int timeout = XmlStatement.parserTimeout(element.getAttribute("timeout"));
            boolean batch = Boolean.valueOf(element.getAttribute("batch"));
            String cache = element.getAttribute("cache");
            String hint = element.getAttribute("hint");
            String returnType = element.getAttribute("returnType");
            String groupBy = element.getAttribute("groupBy");
            ResultSetType resultSetType = ResultSetType.get(element.getAttribute("resultSetType"));
            ResultSetConcurrency resultSetConcurrency = ResultSetConcurrency.get(element.getAttribute("resultSetConcurrency"));
            ResultSetHoldability resultSetHoldability = ResultSetHoldability.get(element.getAttribute("resultSetHoldability"));
            ValidateType validateType = ValidateType.get(element.getAttribute("validation"));
            tag = this.newTag(nodeName, id, type, isolation, timeout, batch, cache, hint, resultSetType, resultSetConcurrency, resultSetHoldability, returnType, groupBy, validateType, element, stats);
            tag.setXpath(String.valueOf(xpathSql) + "[@id='" + id + "']");
            tag.setResourceName(this.resourceName);
            int j = 0;
            while (j < element.getChildNodes().getLength()) {
                ITextTag textTag = this.getDynamicNode(element.getChildNodes().item(j));
                if (tag.isInsertable() && textTag instanceof AutoGeneratedKey) {
                    AutoGeneratedKey autoGeneratedKeyTag = (AutoGeneratedKey)textTag;
                    Insertable insertTag = (Insertable)((Object)tag);
                    insertTag.setAutoGeneratedKey(autoGeneratedKeyTag);
                } else if (textTag instanceof ITextTag) {
                    tag.addTag(textTag);
                }
                ++j;
            }
        }
        return tag;
    }

    private ProcedureTag buildProcedure(Element element, String xpathSql, Statistical stats) {
        String id = element.getAttribute("id");
        String spName = element.getAttribute("spname");
        ProcedureTag tag = new ProcedureTag(id, LanguageType.STORED, stats);
        tag.setSpName(spName);
        tag.setResourceName(this.resourceName);
        tag.setXpath(xpathSql);
        ProcedureParameterTag[] paramsTag = this.processParameterTag(element);
        tag.setParams(paramsTag);
        return tag;
    }

    private AutoGeneratedKey processAutoGenerateKeyTag(Element element) {
        String type = element.getAttribute("strategy");
        String columns = element.getAttribute("columns");
        String props = element.getAttribute("properties");
        String text = element.getTextContent();
        AutoGeneratedKey tag = TagFactory.newAutoGeneratedKey(type, columns, props, text);
        return tag;
    }

    private void processProcedureElements(String expressionXpath, String packet, Map<String, Sql> statements, RepositoryConfig repositoryConfig) {
        SqlDialect sqlDialect = repositoryConfig.getSqlDialect();
        String xpathSql = String.format(expressionXpath, packet);
        NodeList procedures = this.xmlReader.evaluateXpath(expressionXpath);
        if (procedures != null) {
            int s = 0;
            while (s < procedures.getLength()) {
                Node firstNode = procedures.item(s);
                if (firstNode.getNodeType() == 1) {
                    Element element = (Element)firstNode;
                    ProcedureTag tag = this.buildProcedure(element, xpathSql, repositoryConfig.getStatistical());
                    tag.bind(sqlDialect);
                    Sql oldSql = this.put(packet, statements, tag);
                    if (oldSql != null) {
                        LOG.info("SQL {} was updated", (Object)oldSql.getName());
                    }
                }
                ++s;
            }
        }
    }

    private Sql put(String packet, Map<String, Sql> statements, SqlTag tag) {
        Sql oldSql = null;
        if (packet == null || "".equals(packet)) {
            oldSql = statements.put(tag.getName(), tag);
        } else {
            tag.setPackage(packet);
            oldSql = statements.put(String.valueOf(packet) + "." + tag.getName(), tag);
        }
        return oldSql;
    }

    private ProcedureParameterTag[] processParameterTag(Element element) {
        NodeList nodeList = this.xmlReader.evaluateXpath("parameter", element);
        ProcedureParameterTag[] params = new ProcedureParameterTag[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            ProcedureParameterTag tag = null;
            Element ele = (Element)nodeList.item(i);
            String property = ele.getAttribute("property");
            String mode = ele.getAttribute("mode");
            String sqlType = ele.getAttribute("sqlType");
            String typeName = ele.getAttribute("typeName");
            if (!"".equals(typeName) && "IN".equals(mode)) {
                throw new RepositoryException("The parameter [" + property + "] is wrong. There is a typeName [" + typeName + "] but is like IN mode. TypeName must be used with OUT or INOUT");
            }
            if (!"".equals(typeName) && "".equals(sqlType)) {
                throw new RepositoryException("The parameter [" + property + "] is wrong. There is a typeName [" + typeName + "] but dont have a sqlType defined");
            }
            tag = "".equals(sqlType) && "".equals(typeName) ? new ProcedureParameterTag(property, mode) : (!"".equals(typeName) && "".equals(typeName) ? new ProcedureParameterTag(property, mode, sqlType) : new ProcedureParameterTag(property, mode, sqlType, typeName));
            params[i] = tag;
            ++i;
        }
        return params;
    }

    private SqlTag newTag(String nodeName, String id, LanguageType type, Isolation isolation, int timeout, boolean batch, String cache, String hint, ResultSetType resultSetType, ResultSetConcurrency resultSetConcurrency, ResultSetHoldability resultSetHoldability, String returnType, String groupBy, ValidateType validateType, Element element, Statistical stats) {
        SqlTag tag = null;
        if ("select".equals(nodeName)) {
            tag = (SqlTag)((Object)TagFactory.newSelect(id, type, isolation, timeout, cache, resultSetType, resultSetConcurrency, resultSetHoldability, returnType, groupBy, validateType, stats));
            NodeList oneToManyList = this.xmlReader.evaluateXpath("one-to-many", element);
            int i = 0;
            while (i < oneToManyList.getLength()) {
                OneToManyTag tagOtM = null;
                Element ele = (Element)oneToManyList.item(i);
                String property = ele.getAttribute("property");
                String typeOf = ele.getAttribute("typeOf");
                String impl = ele.getAttribute("impl");
                tagOtM = TagFactory.newOneToMany(property, typeOf, impl);
                ((Selectable)((Object)tag)).addOneToMany(tagOtM);
                ++i;
            }
        } else if ("insert".equals(nodeName)) {
            tag = (SqlTag)((Object)TagFactory.newInsert(id, type, isolation, timeout, validateType, stats));
        } else if ("update".equals(nodeName)) {
            tag = (SqlTag)((Object)TagFactory.newUpdate(id, type, isolation, timeout, validateType, stats));
        } else if ("delete".equals(nodeName)) {
            tag = (SqlTag)((Object)TagFactory.newDelete(id, type, isolation, timeout, validateType, stats));
        } else if ("procedure".equals(nodeName)) {
            tag = new ProcedureTag(id, type, isolation, timeout, ValidateType.NONE, stats);
        }
        return tag;
    }

    private ITextTag getDynamicNode(Node node) {
        String nodeName = node.getNodeName();
        String text = node.getNodeValue();
        ITextTag tag = null;
        if ("if".equals(nodeName)) {
            Element element = (Element)node;
            tag = new IfTag(element.getAttribute("test"), this.xmlReader.getTextFromElement(element));
        } else if ("where".equals(nodeName)) {
            Element element = (Element)node;
            List<ITextTag> listIfTag = this.processTagDecision(element);
            tag = new WhereTag(listIfTag);
        } else if ("set".equals(nodeName)) {
            Element element = (Element)node;
            List<ITextTag> listIfTag = this.processTagDecision(element);
            tag = new SetTag(listIfTag);
        } else if ("choose".equals(nodeName)) {
            Element element = (Element)node;
            List<WhenTag> listWhenTag = this.processWhenTag(element);
            tag = new ChooseTag(listWhenTag);
        } else if ("autoGeneratedKey".equals(nodeName)) {
            Element element = (Element)node;
            tag = this.processAutoGenerateKeyTag(element);
        } else if (text != null && !"".equals(text = text.trim())) {
            tag = new StaticText(text);
        }
        return tag;
    }

    private List<ITextTag> processTagDecision(Element element) {
        ArrayList<ITextTag> list = new ArrayList<ITextTag>();
        NodeList nodeList = this.xmlReader.evaluateXpath("if | choose", element);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element elementNode = (Element)nodeList.item(i);
            if ("if".equalsIgnoreCase(elementNode.getTagName())) {
                IfTag tag = new IfTag(elementNode.getAttribute("test"), this.xmlReader.getTextFromElement(elementNode));
                list.add(i, tag);
            } else if ("choose".equalsIgnoreCase(elementNode.getTagName())) {
                List<WhenTag> listWhen = this.processWhenTag(elementNode);
                list.add(new ChooseTag(listWhen));
            }
            ++i;
        }
        return list;
    }

    private List<WhenTag> processWhenTag(Element element) {
        WhenTag tag;
        ArrayList<WhenTag> list = new ArrayList<WhenTag>();
        NodeList nodeList = this.xmlReader.evaluateXpath("when", element);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element whnEle = (Element)nodeList.item(i);
            tag = new WhenTag(whnEle.getAttribute("test"), this.xmlReader.getTextFromElement(whnEle));
            list.add(i, tag);
            ++i;
        }
        nodeList = this.xmlReader.evaluateXpath("otherwise", element);
        i = 0;
        while (i < nodeList.getLength()) {
            Element otherEle = (Element)nodeList.item(i);
            tag = new OtherwiseTag(this.xmlReader.getTextFromElement(otherEle));
            list.add(tag);
            if (i > 0) {
                throw new RepositoryException("There are more one <otherwise> tag inner <choose> tag");
            }
            ++i;
        }
        return list;
    }

    private static int parserTimeout(String time) {
        int timeout = -1;
        if (time != null) {
            try {
                timeout = Integer.parseInt(time);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "XmlStatement [resourceName=" + this.resourceName + ", timestamp=" + this.timestamp + "]";
    }
}

