/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.jkniv.sqlegance.DefaultClassLoader;
import net.sf.jkniv.sqlegance.RepositoryException;
import net.sf.jkniv.sqlegance.builder.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(XmlReader.class);
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private String resourceName;
    private Document doc;
    private Date timestamp;
    private String version;
    private String schemaXsd;

    public XmlReader(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean load() {
        URL url;
        boolean loaded;
        InputStream is;
        block6: {
            is = null;
            loaded = false;
            try {
                LOG.info("Loading XML resource [{}] from class path", (Object)this.resourceName);
                url = DefaultClassLoader.getResource(this.resourceName);
                if (url != null) break block6;
                LOG.warn("Cannot load XML resource [{}] from class path", (Object)this.resourceName);
                this.closeStream(is);
                return false;
            }
            catch (Throwable throwable) {
                this.closeStream(is);
                throw throwable;
            }
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            LOG.error("Cannot open xml file [{}]", (Object)this.resourceName, (Object)e);
        }
        if (is != null) {
            this.doc = this.loadXML(is);
            this.doc.getDocumentElement().normalize();
            loaded = true;
            this.setVersion();
        }
        this.closeStream(is);
        XmlValidator.validate(this.getXsdUrl(), this.resourceName);
        return loaded;
    }

    private Document loadXML(InputStream xml) {
        Document doc = null;
        if (xml == null) {
            throw new RepositoryException("There is XML file '<include href=...' that is not correctly named, check the name from your xml files at '<include href=...' tag. The file path is absolute and must agree that package is.");
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(xml);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error in parser the xml file [" + xml + "]. ParserConfigurationException: " + e.getMessage() + ". Verify if the name from file start with '/' and contains the package, because the path is absolute");
        }
        catch (SAXException e) {
            throw new RuntimeException("Error in parser the xml file [" + xml + "]. SAXException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Error in parser the xml file [" + xml + "]. IOException: " + e.getMessage());
        }
        return doc;
    }

    public NodeList evaluateXpath(String expressionXpath) {
        return this.evaluateXpath(expressionXpath, true);
    }

    public NodeList evaluateXpath(String expressionXpath, boolean logEnable) {
        NodeList nodeList;
        block2: {
            nodeList = null;
            try {
                XPathExpression exp = xpath.compile(expressionXpath);
                nodeList = (NodeList)exp.evaluate(this.doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                if (!logEnable) break block2;
                LOG.info("XPath is wrong: " + expressionXpath);
            }
        }
        return nodeList;
    }

    public NodeList evaluateXpath(String expressionXpath, Element element) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xpath.evaluate(expressionXpath, element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            LOG.info("XPath is wrong: " + expressionXpath);
        }
        return nodeList;
    }

    public String getTextFromElement(Element element) {
        String text = element.getChildNodes().item(0).getNodeValue().trim();
        if ((text == null || "".equals(text)) && element.getChildNodes().item(0).getNextSibling() != null) {
            text = element.getChildNodes().item(0).getNextSibling().getNodeValue().trim();
        }
        return text;
    }

    public Element getFirstElement(String xpath) {
        Node node;
        Element element = null;
        NodeList list = this.evaluateXpath(xpath, false);
        if (list != null && list.getLength() > 0 && (node = list.item(0)).getNodeType() == 1) {
            element = (Element)node;
        }
        return element;
    }

    private void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.warn("Cannot close input stream [{}]", (Object)this.resourceName);
            }
        }
    }

    private URL[] getXsdUrl() {
        String mainSchema = this.schemaXsd;
        String cacheSchema = "/net/sf/jkniv/sqlegance/builder/xml/sqlegance-cache.xsd";
        if (this.version != null && !"".equals(this.version.trim())) {
            mainSchema = mainSchema.replaceAll(".xsd", "-" + this.version + ".xsd");
            cacheSchema = "/net/sf/jkniv/sqlegance/builder/xml/sqlegance-cache-" + this.version + ".xsd";
        }
        URL schema1 = this.getClass().getResource(mainSchema);
        URL schema2 = this.getClass().getResource(cacheSchema);
        return new URL[]{schema1, schema2};
    }

    private void setVersion() {
        Node first = this.doc.getFirstChild();
        if (first instanceof Element) {
            Element e = (Element)first;
            this.version = e.getAttribute("version");
            this.schemaXsd = "statements".equals(e.getTagName()) ? "/net/sf/jkniv/sqlegance/builder/xml/sqlegance-stmt.xsd" : ("repository-config".equals(e.getTagName()) ? "/net/sf/jkniv/sqlegance/builder/xml/sqlegance-config.xsd" : "/net/sf/jkniv/sqlegance/builder/xml/sqlegance-stmt.xsd");
        }
    }

    public String toString() {
        return "XmlReader [resourceName=" + this.resourceName + ", timestamp=" + this.timestamp + "]";
    }
}

