/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.sf.jkniv.sqlegance.DefaultClassLoader;
import net.sf.jkniv.sqlegance.builder.ClassPathSqlContext;
import net.sf.jkniv.sqlegance.builder.XmlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReloadableXmlResource {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableXmlResource.class);
    private static final int WAIT_TIME_TO_CANCEL = 3;
    private static final TimeUnit TIME = TimeUnit.HOURS;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    ReloadableXmlResource() {
    }

    public void pooling(ClassPathSqlContext context) {
        WatchResources watching = new WatchResources(context);
        final ScheduledFuture<?> poolScheduler = this.scheduler.scheduleAtFixedRate(watching, 5L, 5L, TimeUnit.SECONDS);
        LOG.info("Watching XML resources for next {} {} to load changes", (Object)3, (Object)TIME);
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                LOG.info("Cancel watching XML resources after {} {} execution.", (Object)3, (Object)TIME);
                poolScheduler.cancel(true);
            }
        }, 3L, TIME);
    }

    class WatchResources
    implements Runnable {
        private final ClassPathSqlContext context;

        public WatchResources(ClassPathSqlContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            Map<String, List<XmlStatement>> resources = this.context.getResources();
            Set<String> parents = resources.keySet();
            for (String parent : parents) {
                XmlStatement xmlStatement2;
                List<XmlStatement> xmlStatements = resources.get(parent);
                boolean mustReload = false;
                for (XmlStatement xmlStatement2 : xmlStatements) {
                    URL url = DefaultClassLoader.getResource(xmlStatement2.getResourceName());
                    File file = new File(url.getFile());
                    Date lastModified = new Date(file.lastModified());
                    if (!xmlStatement2.getTimestamp().before(lastModified)) continue;
                    mustReload = true;
                    break;
                }
                if (!mustReload) continue;
                LOG.info("Auto reloading xml [{}] resource building", xmlStatements);
                xmlStatement2 = xmlStatements.get(0);
                xmlStatement2.build(this.context.getRepositoryConfig());
            }
        }
    }
}

