/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jkniv.sqlegance.RepositoryException;
import net.sf.jkniv.sqlegance.validation.ValidationMessage;

public class ConstraintException
extends RepositoryException {
    private static final long serialVersionUID = -1607171467309827392L;
    private final Map<String, String> violations;
    private final List<ValidationMessage> violationsList;

    public ConstraintException(String param, String message) {
        super(message);
        this.violations = new TreeMap<String, String>();
        this.violationsList = new ArrayList<ValidationMessage>();
        this.violations.put(param, message);
    }

    public ConstraintException(Map<String, String> violations) {
        this.violationsList = new ArrayList<ValidationMessage>();
        this.violations = violations;
    }

    public ConstraintException(List<ValidationMessage> violationsList) {
        this.violationsList = violationsList;
        this.violations = new TreeMap<String, String>();
        for (ValidationMessage message : violationsList) {
            this.violations.put(message.getField(), message.getValue());
        }
    }

    public Map<String, String> getViolations() {
        return Collections.unmodifiableMap(this.violations);
    }

    public List<ValidationMessage> getViolationsI18n() {
        return Collections.unmodifiableList(this.violationsList);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getClass().getName()) + ": ");
        sb.append(super.getMessage() == null ? "There " + (this.violations.size() > 1 ? "are " : "is ") + this.violations.size() + " data violations" : super.getMessage());
        for (String k : this.violations.keySet()) {
            sb.append("\n\t[" + k + "]=" + this.violations.get(k));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

