/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.params;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jkniv.sqlegance.params.AbstractParamParser;
import net.sf.jkniv.sqlegance.params.ParamMarkType;
import net.sf.jkniv.sqlegance.params.ParamParser;

public class ParamParserHashMark
extends AbstractParamParser {
    private static final Pattern PATTERN_PARAMS = Pattern.compile("(#\\{[\\w\\.?]+\\}|:in:[\\w\\.?]+|'[^']*')+", 10);
    private static ParamParser INSTANCE = new ParamParserHashMark();

    private ParamParserHashMark() {
    }

    public static ParamParser getInstance() {
        return INSTANCE;
    }

    @Override
    Pattern getPatternParams() {
        return PATTERN_PARAMS;
    }

    @Override
    public String[] find(String query) {
        return this.parserHash(query).toArray(new String[0]);
    }

    @Override
    public ParamMarkType getType() {
        return ParamMarkType.HASH;
    }

    private List<String> parserHash(String sentence) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcherHash = PATTERN_PARAMS.matcher(sentence);
        int i = 0;
        while (matcherHash.find()) {
            if (matcherHash.group().startsWith("'")) continue;
            if (matcherHash.group().startsWith(":in:")) {
                params.add(i++, sentence.subSequence(matcherHash.start() + 1, matcherHash.end()).toString());
                continue;
            }
            params.add(i++, sentence.subSequence(matcherHash.start() + 2, matcherHash.end() - 1).toString());
        }
        return params;
    }
}

