/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.dialect;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.reflect.beans.PropertyAccess;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import net.sf.jkniv.sqlegance.dialect.SqlFeature;
import net.sf.jkniv.sqlegance.dialect.SqlFeatureFactory;
import net.sf.jkniv.sqlegance.dialect.SqlFeatureSupport;
import net.sf.jkniv.sqlegance.params.ParamMarkType;

public class AnsiDialect
implements SqlDialect {
    private static final Assertable notNull = AssertsFactory.getNotNull();
    private static final String REGEX_START_WITH = "^\\s*(with)\\s";
    private static final String REGEX_START_SELECT = "^\\s*(select)\\s";
    private static final String REGEX_START_SELECT_DISTINCT = "^\\s*(select\\s+distinct|select)\\s";
    private static final String REGEX_ENDS_FORUPDATE = "\\s+(for\\s+update)\\s*$";
    private static final String REGEX_ENDS_ORDERBY = "\\s*(order\\s+by)\\s*[a-zA-Z0-9,_\\.\\)\\s]*$";
    private static final Pattern patternWith = Pattern.compile("^\\s*(with)\\s", 10);
    private static final Pattern patternSelect = Pattern.compile("^\\s*(select)\\s", 10);
    private static final Pattern patternSelectDistinct = Pattern.compile("^\\s*(select\\s+distinct|select)\\s", 10);
    private static final Pattern patternForUpdate = Pattern.compile("\\s+(for\\s+update)\\s*$", 10);
    public static final Pattern patternORDER_BY = Pattern.compile("\\s*(order\\s+by)\\s*[a-zA-Z0-9,_\\.\\)\\s]*$", 10);
    protected String name = this.getClass().getSimpleName();
    private final HashMap<SqlFeatureSupport, SqlFeature> sqlFeatures = new HashMap();
    private int maxOfParameters;
    private PropertyAccess propertyAccessId;
    private PropertyAccess propertyAccessRevision;

    public AnsiDialect() {
        this.sqlFeatures.put(SqlFeatureSupport.LIMIT, SqlFeatureFactory.newInstance(SqlFeatureSupport.LIMIT));
        this.sqlFeatures.put(SqlFeatureSupport.LIMIT_OFF_SET, SqlFeatureFactory.newInstance(SqlFeatureSupport.LIMIT_OFF_SET));
        this.sqlFeatures.put(SqlFeatureSupport.ROWNUM, SqlFeatureFactory.newInstance(SqlFeatureSupport.ROWNUM));
        this.sqlFeatures.put(SqlFeatureSupport.STMT_HOLDABILITY, SqlFeatureFactory.newInstance(SqlFeatureSupport.STMT_HOLDABILITY));
        this.sqlFeatures.put(SqlFeatureSupport.CONN_HOLDABILITY, SqlFeatureFactory.newInstance(SqlFeatureSupport.CONN_HOLDABILITY, true));
        this.sqlFeatures.put(SqlFeatureSupport.BOOKMARK_QUERY, SqlFeatureFactory.newInstance(SqlFeatureSupport.BOOKMARK_QUERY));
        this.sqlFeatures.put(SqlFeatureSupport.PAGING_ROUNDTRIP, SqlFeatureFactory.newInstance(SqlFeatureSupport.PAGING_ROUNDTRIP, true));
        this.sqlFeatures.put(SqlFeatureSupport.SEQUENCE, SqlFeatureFactory.newInstance(SqlFeatureSupport.SEQUENCE));
        this.maxOfParameters = Integer.MAX_VALUE;
        this.propertyAccessId = new PropertyAccess("id", "getId", "setId");
        this.propertyAccessRevision = new PropertyAccess("rev", "getRev", "setRev");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean supportsFeature(SqlFeatureSupport feature) {
        boolean answer = false;
        SqlFeature sqlFeature = this.sqlFeatures.get((Object)feature);
        if (sqlFeature != null) {
            answer = sqlFeature.supports();
        }
        return answer;
    }

    @Override
    public boolean supportsParmMark(ParamMarkType paramParse) {
        return true;
    }

    @Override
    public SqlFeature addFeature(SqlFeature sqlFeature) {
        return this.sqlFeatures.put(sqlFeature.getSqlFeature(), sqlFeature);
    }

    @Override
    public int getMaxOfParameters() {
        return this.maxOfParameters;
    }

    @Override
    public void setMaxOfParameters(int max) {
        if (max > 0) {
            this.maxOfParameters = max;
        }
    }

    @Override
    public String getSqlPatternCount() {
        return "select count(1) from (%1$s) jkniv_ct_tmp_table";
    }

    @Override
    public String getSqlPatternPaging() {
        StringBuilder pattern = new StringBuilder("%1$s");
        if (this.supportsFeature(SqlFeatureSupport.LIMIT)) {
            pattern.append(" LIMIT %2$s");
            if (this.supportsFeature(SqlFeatureSupport.LIMIT_OFF_SET)) {
                pattern.append(", %3$s");
            }
        }
        return pattern.toString();
    }

    @Override
    public String buildQueryPaging(String sqlText, int offset, int max) {
        String sqlTextPaginated = null;
        if (this.supportsFeature(SqlFeatureSupport.LIMIT)) {
            String pagingSelectTemplate = this.getSqlPatternPaging();
            Matcher matcher = this.sqlEndWithForUpdate(sqlText);
            String forUpdate = "";
            String sqlTextWithouForUpdate = sqlText;
            if (matcher.find()) {
                forUpdate = sqlText.substring(matcher.start(), matcher.end());
                sqlTextWithouForUpdate = sqlText.substring(0, matcher.start());
            }
            sqlTextPaginated = this.supportsFeature(SqlFeatureSupport.LIMIT_OFF_SET) ? String.valueOf(String.format(pagingSelectTemplate, sqlTextWithouForUpdate, max, offset)) + forUpdate : String.valueOf(String.format(pagingSelectTemplate, sqlTextWithouForUpdate, max)) + forUpdate;
        }
        return sqlTextPaginated;
    }

    @Override
    public String buildQueryPaging(String sqlText, int offset, int max, String bookmark) {
        return this.buildQueryPaging(sqlText, offset, max);
    }

    @Override
    public PropertyAccess getAccessId() {
        return this.propertyAccessId;
    }

    @Override
    public PropertyAccess getAccessRevision() {
        return this.propertyAccessRevision;
    }

    @Override
    public String buildQueryCount(String sqlText) {
        String sqlToCount = null;
        Matcher matcher = this.sqlEndWithForUpdate(sqlText);
        sqlToCount = matcher.find() ? String.format(this.getSqlPatternCount(), sqlText.substring(0, matcher.start())) : String.format(this.getSqlPatternCount(), this.removeOrderBy(sqlText));
        return sqlToCount;
    }

    protected Matcher sqlStartWithSelect(String sql) {
        Matcher matcher = patternSelect.matcher(sql);
        return matcher;
    }

    protected Matcher sqlStartWithSelectOrDistinct(String sql) {
        Matcher matcher = patternSelectDistinct.matcher(sql);
        return matcher;
    }

    protected Matcher sqlEndsWithOrderBy(String sql) {
        Matcher matcher = patternORDER_BY.matcher(sql);
        return matcher;
    }

    protected Matcher sqlEndWithForUpdate(String sql) {
        Matcher matcher = patternForUpdate.matcher(sql);
        return matcher;
    }

    private String removeOrderBy(String hql) {
        Matcher m = patternORDER_BY.matcher(hql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (!m.hitEnd()) continue;
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }
}

