/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder.xml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jkniv.cache.Cacheable;
import net.sf.jkniv.cache.MemoryCache;
import net.sf.jkniv.cache.NoCache;
import net.sf.jkniv.sqlegance.LanguageType;
import net.sf.jkniv.sqlegance.OneToMany;
import net.sf.jkniv.sqlegance.Selectable;
import net.sf.jkniv.sqlegance.SqlType;
import net.sf.jkniv.sqlegance.Statistical;
import net.sf.jkniv.sqlegance.builder.xml.AbstractSqlTag;
import net.sf.jkniv.sqlegance.builder.xml.SqlStats;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import net.sf.jkniv.sqlegance.statement.ResultSetConcurrency;
import net.sf.jkniv.sqlegance.statement.ResultSetHoldability;
import net.sf.jkniv.sqlegance.statement.ResultSetType;
import net.sf.jkniv.sqlegance.transaction.Isolation;
import net.sf.jkniv.sqlegance.validation.ValidateType;

class SelectTag
extends AbstractSqlTag
implements Selectable {
    private String groupBy;
    private Set<OneToMany> oneToMany;
    private String cacheName;
    private Cacheable cache;
    private Statistical statsPaging;

    public SelectTag(String id, LanguageType languageType) {
        super(id, languageType);
        this.init();
    }

    public SelectTag(String id, LanguageType languageType, SqlDialect sqlDialect) {
        super(id, languageType, sqlDialect);
        this.init();
    }

    public SelectTag(String id, LanguageType languageType, Isolation isolation, int timeout, String cacheName, ResultSetType resultSetType, ResultSetConcurrency resultSetConcurrency, ResultSetHoldability resultSetHoldability, String returnType, String groupBy, ValidateType validateType, Statistical stats) {
        super(id, languageType, isolation, timeout, resultSetType, resultSetConcurrency, resultSetHoldability, returnType, validateType, stats);
        this.groupBy = groupBy;
        this.oneToMany = new HashSet<OneToMany>();
        this.cacheName = cacheName;
        this.statsPaging = new SqlStats();
        this.cache = cacheName != null && !"".equals(cacheName.trim()) ? new MemoryCache(cacheName) : NoCache.getInstance();
    }

    private void init() {
        this.oneToMany = new HashSet<OneToMany>();
        this.groupBy = "";
        this.cacheName = null;
        this.cache = NoCache.getInstance();
        this.statsPaging = new SqlStats();
    }

    @Override
    public String getTagName() {
        return "select";
    }

    @Override
    public SqlType getSqlType() {
        return SqlType.SELECT;
    }

    @Override
    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    @Override
    public List<String> getGroupByAsList() {
        if (this.groupBy == null || "".equals(this.groupBy)) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.groupBy.split(","));
    }

    @Override
    public Set<OneToMany> getOneToMany() {
        return this.oneToMany;
    }

    @Override
    public void addOneToMany(OneToMany oneToMany) {
        this.oneToMany.add(oneToMany);
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public Selectable asSelectable() {
        return this;
    }

    @Override
    public boolean hasCache() {
        return this.cacheName != null && !"".equals(this.cacheName.trim());
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public <K, V> Cacheable<K, V> getCache() {
        return this.cache;
    }

    @Override
    public Statistical getStatsPaging() {
        return this.statsPaging;
    }
}

