/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder.xml;

import java.util.concurrent.atomic.AtomicLong;
import net.sf.jkniv.sqlegance.Statistical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractStats
implements Statistical {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStats.class);
    private AtomicLong max = new AtomicLong();
    private AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private AtomicLong total = new AtomicLong();
    private AtomicLong count;
    private AtomicLong firstTime = null;
    private AtomicLong lastTime = new AtomicLong();
    private AtomicLong totalException;
    private Exception firstException;
    private Exception lastException;

    public AbstractStats() {
        this.count = new AtomicLong();
        this.totalException = new AtomicLong();
    }

    @Override
    public void add(long time) {
        if (time > this.max.get()) {
            this.max.set(time);
        }
        if (time < this.min.get()) {
            this.min.set(time);
        }
        if (this.firstTime == null) {
            this.firstTime = new AtomicLong(time);
        }
        this.lastTime.set(time);
        this.count.getAndIncrement();
        this.total.addAndGet(time);
        LOG.trace("added {} ms with total of {} the {} time", new Object[]{time, this.total, this.count});
    }

    @Override
    public void add(Exception e) {
        this.totalException.incrementAndGet();
        if (e != null) {
            if (this.firstException == null) {
                this.firstException = e;
            }
            this.lastException = e;
        }
    }

    @Override
    public long getMaxTime() {
        return this.max.get();
    }

    @Override
    public long getMinTime() {
        return this.min.get();
    }

    @Override
    public long getAvgTime() {
        return this.total.get() / this.count.get();
    }

    @Override
    public long getTotalTime() {
        return this.total.get();
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public long getFirstTime() {
        return this.firstTime != null ? this.firstTime.get() : 0L;
    }

    @Override
    public long getLastTime() {
        return this.lastTime.get();
    }

    @Override
    public long getTotalException() {
        return this.totalException.get();
    }

    @Override
    public Exception getFirstException() {
        return this.firstException;
    }

    @Override
    public Exception getLastException() {
        return this.lastException;
    }

    public String toString() {
        return "AbstractStats [max=" + this.max + ", min=" + this.min + ", total=" + this.total + ", count=" + this.count + ", firstTime=" + this.firstTime + ", lastTime=" + this.lastTime + ", totalException=" + this.totalException + ", firstException=" + (this.firstException != null ? this.firstException.getMessage() : "") + ", lastException=" + (this.lastException != null ? this.lastException.getMessage() : "") + "]";
    }
}

