/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.sf.jkniv.cache.CacheManager;
import net.sf.jkniv.cache.CachePolicy;
import net.sf.jkniv.cache.TTLCachePolicy;
import net.sf.jkniv.sqlegance.LanguageType;
import net.sf.jkniv.sqlegance.QueryNotFoundException;
import net.sf.jkniv.sqlegance.RepositoryException;
import net.sf.jkniv.sqlegance.Selectable;
import net.sf.jkniv.sqlegance.Sql;
import net.sf.jkniv.sqlegance.SqlContext;
import net.sf.jkniv.sqlegance.SqlType;
import net.sf.jkniv.sqlegance.builder.ReloadableXmlResource;
import net.sf.jkniv.sqlegance.builder.RepositoryConfig;
import net.sf.jkniv.sqlegance.builder.XmlStatement;
import net.sf.jkniv.sqlegance.builder.xml.AbstractSqlTag;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ClassPathSqlContext
implements SqlContext {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathSqlContext.class);
    private final Map<String, Sql> statements;
    private final String mainResourceName;
    private final RepositoryConfig repositoryConfig;
    private final boolean shortnameEnable;
    private final String contextName;
    private final Map<String, List<XmlStatement>> resources;
    private CacheManager cacheManager;

    public ClassPathSqlContext(String resourceName) {
        this(resourceName, null, new Properties());
    }

    public ClassPathSqlContext(String resourceName, Properties props) {
        this(resourceName, null, props);
    }

    public ClassPathSqlContext(String resourceName, String repoConfigName, Properties props) {
        long initial = System.currentTimeMillis();
        this.mainResourceName = resourceName;
        this.statements = new HashMap<String, Sql>();
        this.resources = new HashMap<String, List<XmlStatement>>();
        XmlStatement xmlStatementMain = this.preLoad(this.mainResourceName);
        String defaultContextName = this.getDefaultContextName(xmlStatementMain);
        this.repositoryConfig = new RepositoryConfig(repoConfigName == null ? defaultContextName : repoConfigName);
        this.repositoryConfig.add(props);
        this.shortnameEnable = this.repositoryConfig.isShotKeyEnable();
        this.build(xmlStatementMain, resourceName);
        this.contextName = this.isEmpty(defaultContextName) ? this.repositoryConfig.getName() : defaultContextName;
        if (this.repositoryConfig.isReloadableXmlEnable()) {
            ReloadableXmlResource reloadable = new ReloadableXmlResource();
            reloadable.pooling(this);
        }
        LOG.info("{} SQL was loaded at {} ms", (Object)this.statements.size(), (Object)(System.currentTimeMillis() - initial));
    }

    @Override
    public Sql getQuery(String name) {
        Sql sql = this.statements.get(name);
        if (sql == null) {
            throw new QueryNotFoundException("Query not found [" + name + "]");
        }
        if (sql instanceof Duplicate) {
            throw new QueryNotFoundException("There are duplicate short name [" + name + "] for this statement, use fully name to recover it");
        }
        return sql;
    }

    @Override
    public Sql add(Sql sql) {
        return this.add(sql.getName(), sql);
    }

    @Override
    public List<Sql> getPackage(String packageName) {
        ArrayList<Sql> queries = new ArrayList<Sql>();
        for (Sql sql : this.statements.values()) {
            if (!packageName.equals(sql.getPackage())) continue;
            queries.add(sql);
        }
        return Collections.unmodifiableList(queries);
    }

    @Override
    public Map<String, List<Sql>> getPackageStartWith(String packageName) {
        LinkedHashMap<String, ArrayList<Sql>> queries = new LinkedHashMap<String, ArrayList<Sql>>();
        for (Sql sql : this.statements.values()) {
            if (sql.getPackage() == null || !sql.getPackage().startsWith(packageName)) continue;
            ArrayList<Sql> packet = (ArrayList<Sql>)queries.get(sql.getPackage());
            if (packet == null) {
                packet = new ArrayList<Sql>();
                queries.put(sql.getPackage(), packet);
            }
            packet.add(sql);
        }
        return Collections.unmodifiableMap(queries);
    }

    public String getContextName() {
        return this.contextName;
    }

    private String getDefaultContextName(XmlStatement xmlStatementMain) {
        String name = null;
        Element element = xmlStatementMain.getFirstElement("statements");
        if (element != null) {
            name = element.getAttribute("context");
        }
        return name;
    }

    @Override
    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    Map<String, List<XmlStatement>> getResources() {
        return this.resources;
    }

    void appendResource(String resourceName) {
        XmlStatement xmlStatement = this.preLoad(resourceName);
        this.build(xmlStatement, resourceName);
    }

    private XmlStatement preLoad(String resourceName) {
        XmlStatement xmlStatementMain = new XmlStatement(resourceName);
        xmlStatementMain.load();
        return xmlStatementMain;
    }

    private void build(XmlStatement xmlStatementMain, String resourceName) {
        this.addResource(resourceName, xmlStatementMain);
        NodeList filesInc = xmlStatementMain.evaluateXpath("//include");
        if (filesInc != null) {
            int i = 0;
            while (i < filesInc.getLength()) {
                Element e = (Element)filesInc.item(i);
                String filename = e.getAttribute("href");
                XmlStatement xmlStatementInclude = new XmlStatement(filename);
                xmlStatementInclude.load();
                this.addResource(resourceName, xmlStatementInclude);
                this.processXML(xmlStatementInclude);
                ++i;
            }
        }
        Map<String, Sql> readStatements = xmlStatementMain.build(this.repositoryConfig);
        this.configCacheManager(xmlStatementMain);
        for (Map.Entry<String, Sql> entry : readStatements.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        if (this.cacheManager != null) {
            for (Map.Entry<String, Sql> entry : this.statements.entrySet()) {
                if (!entry.getValue().isSelectable() || !entry.getValue().asSelectable().hasCache()) continue;
                Selectable selectable = entry.getValue().asSelectable();
                this.cacheManager.add(entry.getKey(), selectable.getCacheName(), selectable.getCache());
            }
            if (this.cacheManager.size() > 0) {
                this.cacheManager.pooling();
            }
        }
    }

    private void processXML(XmlStatement xmlStatement) {
        NodeList filesInc = xmlStatement.evaluateXpath("//include");
        this.addResource(xmlStatement.getResourceName(), xmlStatement);
        if (filesInc != null) {
            int i = 0;
            while (i < filesInc.getLength()) {
                Element e = (Element)filesInc.item(i);
                String filename = e.getAttribute("href");
                XmlStatement xmlStatementInclude = new XmlStatement(filename);
                xmlStatementInclude.load();
                this.processXML(xmlStatementInclude);
                this.addResource(xmlStatement.getResourceName(), xmlStatementInclude);
                ++i;
            }
        }
        Map<String, Sql> readStatements = xmlStatement.build(this.repositoryConfig);
        this.configCacheManager(xmlStatement);
        for (Map.Entry<String, Sql> entry : readStatements.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    private void configCacheManager(XmlStatement xmlStatement) {
        if (this.cacheManager != null) {
            throw new RepositoryException("There is already a configured cache manager " + this.cacheManager + ", just one for SqlContext is permitted");
        }
        NodeList nodes = xmlStatement.evaluateXpath("statements/cache-manager");
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    long initalDelay = this.longValueOf(element.getAttribute("delay"), CachePolicy.DEFAULT_INITIALDELAY);
                    long period = this.longValueOf(element.getAttribute("period"), CachePolicy.DEFAULT_PERIOD);
                    long ttl = this.longValueOf(element.getAttribute("ttl"), 60L);
                    long tti = this.longValueOf(element.getAttribute("tti"), -1L);
                    long size = this.longValueOf(element.getAttribute("size"), 1000L);
                    String sizeof = element.getAttribute("sizeof");
                    TTLCachePolicy policy = new TTLCachePolicy(ttl, tti, TimeUnit.SECONDS, size, sizeof);
                    this.cacheManager = new CacheManager(initalDelay, period, (CachePolicy)policy);
                    LOG.info("cache manager ttl[{}] tti[{}] size[{}] sizeOf[{}]", new Object[]{ttl, tti, size, sizeof});
                    NodeList policyNodes = element.getChildNodes();
                    int j = 0;
                    while (j < policyNodes.getLength()) {
                        Node nodePolicy = policyNodes.item(j);
                        if (nodePolicy.getNodeType() == 1) {
                            Element elementPolicy = (Element)nodePolicy;
                            String policyName = elementPolicy.getAttribute("name");
                            ttl = this.longValueOf(elementPolicy.getAttribute("ttl"), 60L);
                            tti = this.longValueOf(elementPolicy.getAttribute("tti"), -1L);
                            size = this.longValueOf(elementPolicy.getAttribute("size"), 1000L);
                            sizeof = element.getAttribute("sizeof");
                            TTLCachePolicy newPolicy = new TTLCachePolicy(ttl, tti, TimeUnit.SECONDS, size, sizeof);
                            this.cacheManager.add(policyName, (CachePolicy)newPolicy);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private long longValueOf(String value, long defaultValue) {
        long v = defaultValue;
        try {
            v = Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v;
    }

    private void addResource(String xmlParent, XmlStatement include) {
        List<XmlStatement> includes = this.resources.get(xmlParent);
        if (includes == null) {
            includes = new ArrayList<XmlStatement>();
            this.resources.put(xmlParent, includes);
        }
        includes.add(include);
    }

    private Sql add(String key, Sql isql) {
        Sql old = null;
        if (key.contains(".") && this.shortnameEnable) {
            String shortName = this.shortName(key);
            if (this.statements.get(shortName) == null) {
                this.statements.put(shortName, isql);
            } else {
                LOG.warn("There is duplicate short name [{}] for statement [{}], use fully name to recover it", (Object)shortName, (Object)key);
                this.statements.put(shortName, new Duplicate(isql.getName(), LanguageType.NATIVE));
            }
        }
        if ((old = this.statements.put(key, isql)) != null) {
            LOG.warn("The statement [{}] from [{}] was replaced from resource [{}]", new Object[]{key, old.getResourceName(), isql.getResourceName()});
        }
        return old;
    }

    private String shortName(String key) {
        String[] keyparts = key.split("\\.");
        String shortKey = keyparts[keyparts.length - 1];
        return shortKey;
    }

    public Map<String, Sql> getStatements() {
        return Collections.unmodifiableMap(this.statements);
    }

    @Override
    public boolean containsQuery(String name) {
        return this.statements.containsKey(name);
    }

    @Override
    public String getName() {
        return this.contextName;
    }

    @Override
    public SqlDialect getSqlDialect() {
        return this.repositoryConfig.getSqlDialect();
    }

    @Override
    public void setSqlDialect(SqlDialect sqlDialect) {
        for (Map.Entry<String, Sql> entry : this.statements.entrySet()) {
            entry.getValue().bind(sqlDialect);
        }
    }

    @Override
    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clean up [{}] statements from [{}] resources [{}]", new Object[]{this.statements.size(), this.resources.size(), this.resources});
        }
        this.resources.clear();
        this.statements.clear();
        if (this.cacheManager != null) {
            this.cacheManager.cancel();
        }
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    static class Duplicate
    extends AbstractSqlTag {
        public Duplicate(String name, LanguageType languageType) {
            super(name, languageType);
        }

        @Override
        public String getTagName() {
            return null;
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.UNKNOWN;
        }

        @Override
        public boolean isSelectable() {
            return false;
        }

        @Override
        public boolean isInsertable() {
            return false;
        }

        @Override
        public boolean isUpdateable() {
            return false;
        }

        @Override
        public boolean isDeletable() {
            return false;
        }

        @Override
        public String getPackage() {
            return "";
        }

        @Override
        public void setPackage(String name) {
        }
    }
}

