/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jkniv.sqlegance.RepositoryException;

public class ConstraintException
extends RepositoryException {
    private static final long serialVersionUID = -1607171467309827392L;
    private final Map<String, String> violations;

    public ConstraintException(String param, String message) {
        super(message);
        this.violations = new TreeMap<String, String>();
        this.violations.put(param, message);
    }

    public ConstraintException(Map<String, String> violations) {
        this.violations = violations;
    }

    public Map<String, String> getViolations() {
        return Collections.unmodifiableMap(this.violations);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getClass().getName()) + ": ");
        sb.append(super.getMessage() == null ? "There " + (this.violations.size() > 1 ? "are " : "is ") + this.violations.size() + " data violations" : super.getMessage());
        for (String k : this.violations.keySet()) {
            sb.append("\n\t[" + k + "]=" + this.violations.get(k));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

