/* 
 * JKNIV, SQLegance keeping queries maintainable.
 * 
 * Copyright (C) 2017, the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.sf.jkniv.sqlegance.builder.xml;

import net.sf.jkniv.sqlegance.KeyGeneratorType;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;

public interface AutoGeneratedKey extends ITextTag
{
    public static final String TAG_NAME           = "autoGeneratedKey";
    public static final String ATTRIBUTE_STRATEGY = "strategy";
    public static final String ATTRIBUTE_COLUMNS  = "columns";
    public static final String ATTRIBUTE_PROPS    = "properties";

    KeyGeneratorType getStrategy();
    
    boolean isAutoStrategy();
    
    boolean isSequenceStrategy();
    
    /**
     * A comma separated list of columns names, when multiple columns are expected
     * @return empty string when haven't value.
     */
    String getColumns();
    
    String[] getColumnsAsArray();
    
    String[] getPropertiesAsArray();
    
    /**
     * A comma separated list of property names, when multiple properties are expected
     * @return empty string when haven't value
     */
    String getProperties();
    
}
