/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder.xml.dynamic;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;

public class WhereTag
implements ITextTag {
    public static final String TAG_NAME = "where";
    private static final Pattern patternAND = Pattern.compile("^(AND|^AND\\s*\\()", 10);
    private static final Pattern patternOR = Pattern.compile("^(OR|^OR\\s*\\()", 10);
    private List<ITextTag> listIfTag;

    public WhereTag(List<ITextTag> listTestTag) {
        this.listIfTag = listTestTag;
    }

    @Override
    public boolean eval(Object rootObjects) {
        boolean evaluation = false;
        for (int i = 0; i < this.listIfTag.size(); ++i) {
            ITextTag tag = this.listIfTag.get(i);
            if (!tag.eval(rootObjects)) continue;
            evaluation = true;
            break;
        }
        return evaluation;
    }

    @Override
    public String getText() {
        throw new IllegalStateException("Conditional tag group cannot getText directly, invoke getText(Object rootObjects)");
    }

    @Override
    public String getText(Object rootObjects) {
        return this.getConditionalText(rootObjects);
    }

    private String getConditionalText(Object rootObjects) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < this.listIfTag.size(); ++i) {
            ITextTag tag = this.listIfTag.get(i);
            if (!tag.eval(rootObjects)) continue;
            String clause = tag.getText();
            if (tag.isDynamicGroup()) {
                clause = tag.getText(rootObjects);
            }
            if (text.indexOf(TAG_NAME) >= 0) {
                text.append(" " + clause);
                continue;
            }
            text.append("where ");
            Matcher matcherAnd = patternAND.matcher(clause);
            Matcher matcherOr = patternOR.matcher(clause);
            if (matcherAnd.find()) {
                text.append(clause.substring(0, matcherAnd.start())).append(clause.substring(matcherAnd.end(), clause.length()).trim());
                continue;
            }
            if (matcherOr.find()) {
                text.append(clause.substring(0, matcherOr.start())).append(clause.substring(matcherOr.end(), clause.length()).trim());
                continue;
            }
            text.append(clause);
        }
        return text.toString();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isDynamicGroup() {
        return true;
    }

    @Override
    public List<? extends ITextTag> getTags() {
        return this.listIfTag;
    }
}

