/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder.xml;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.reflect.beans.ObjectProxyFactory;
import net.sf.jkniv.sqlegance.Deletable;
import net.sf.jkniv.sqlegance.Insertable;
import net.sf.jkniv.sqlegance.LanguageType;
import net.sf.jkniv.sqlegance.Selectable;
import net.sf.jkniv.sqlegance.Statistical;
import net.sf.jkniv.sqlegance.Storable;
import net.sf.jkniv.sqlegance.Updateable;
import net.sf.jkniv.sqlegance.builder.xml.NoSqlStats;
import net.sf.jkniv.sqlegance.builder.xml.SqlTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.StaticText;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.WhereTag;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import net.sf.jkniv.sqlegance.params.ParamMarkType;
import net.sf.jkniv.sqlegance.params.ParamParser;
import net.sf.jkniv.sqlegance.params.ParamParserFactory;
import net.sf.jkniv.sqlegance.params.ParamParserNoMark;
import net.sf.jkniv.sqlegance.statement.ResultSetConcurrency;
import net.sf.jkniv.sqlegance.statement.ResultSetHoldability;
import net.sf.jkniv.sqlegance.statement.ResultSetType;
import net.sf.jkniv.sqlegance.transaction.Isolation;
import net.sf.jkniv.sqlegance.validation.ValidateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlTag
implements SqlTag {
    protected static final Assertable NOT_NULL = AssertsFactory.getNotNull();
    private static final Logger log = LoggerFactory.getLogger(AbstractSqlTag.class);
    private static final String REGEX_HASH_MARK = "#\\{[\\w\\.?]+\\}";
    private static final String REGEX_COLON_MARK = ":[\\w\\.?]+";
    private static final String REGEX_QUESTION_MARK = "[\\?]+";
    private static final String REGEX_DOLLAR_MARK = "\\$[\\w\\.?]+";
    private static final Pattern PATTERN_HASH = Pattern.compile("#\\{[\\w\\.?]+\\}", 10);
    private static final Pattern PATTERN_COLON = Pattern.compile(":[\\w\\.?]+", 10);
    private static final Pattern PATTERN_QUESTION = Pattern.compile("[\\?]+", 10);
    private static final Pattern PATTERN_DOLLAR = Pattern.compile("\\$[\\w\\.?]+", 10);
    public static final String ATTRIBUTE_NAME = "id";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_ISOLATION = "isolation";
    public static final String ATTRIBUTE_TIMEOUT = "timeout";
    public static final String ATTRIBUTE_HINT = "hint";
    public static final String ATTRIBUTE_BATCH = "batch";
    public static final String ATTRIBUTE_CACHE = "cache";
    public static final String ATTRIBUTE_RETURN_TYPE = "returnType";
    public static final String ATTRIBUTE_GROUP_BY = "groupBy";
    public static final String ATTRIBUTE_RESULTSET_TYPE = "resultSetType";
    public static final String ATTRIBUTE_RESULTSET_CONCURRENCY = "resultSetConcurrency";
    public static final String ATTRIBUTE_RESULTSET_HOLDABILITY = "resultSetHoldability";
    public static final String ATTRIBUTE_VALIDATION = "validation";
    protected String id;
    protected LanguageType languageType;
    private Isolation isolation;
    private int timeout;
    private ResultSetType resultSetType;
    private ResultSetConcurrency resultSetConcurrency;
    private ResultSetHoldability resultSetHoldability;
    private ValidateType validateType;
    private List<ITextTag> textTag = new ArrayList<ITextTag>();
    private String returnType;
    private Class<?> returnTypeClass;
    private String xpath;
    private String resourceName;
    private Date timestamp;
    private ParamParser paramParser;
    private String paket;
    private SqlDialect sqlDialect;
    private Statistical stats;

    public AbstractSqlTag(String id, LanguageType languageType) {
        this(id, languageType, Isolation.DEFAULT, -1, ResultSetType.DEFAULT, ResultSetConcurrency.DEFAULT, ResultSetHoldability.DEFAULT, null, ValidateType.NONE, NoSqlStats.getInstance());
    }

    public AbstractSqlTag(String id, LanguageType languageType, SqlDialect sqlDialect) {
        this(id, languageType, Isolation.DEFAULT, -1, ResultSetType.DEFAULT, ResultSetConcurrency.DEFAULT, ResultSetHoldability.DEFAULT, "", ValidateType.NONE, NoSqlStats.getInstance());
        this.sqlDialect = sqlDialect;
    }

    public AbstractSqlTag(String id, LanguageType languageType, Isolation isolation, int timeout, ValidateType validateType, Statistical stats) {
        this(id, languageType, isolation, timeout, ResultSetType.DEFAULT, ResultSetConcurrency.DEFAULT, ResultSetHoldability.DEFAULT, "", validateType, stats);
    }

    public AbstractSqlTag(String id, LanguageType languageType, Isolation isolation, int timeout, ResultSetType resultSetType, ResultSetConcurrency resultSetConcurrency, ResultSetHoldability resultSetHoldability, String returnType, ValidateType validateType, Statistical stats) {
        this.id = id;
        this.languageType = languageType;
        this.isolation = isolation;
        this.timeout = timeout;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.returnType = returnType;
        this.validateType = validateType;
        this.timestamp = new Date();
        this.paramParser = ParamParserNoMark.emptyParser();
        this.stats = stats;
        if (this.hasReturnType()) {
            this.returnTypeClass = ObjectProxyFactory.of((String)returnType).mute(ClassNotFoundException.class).getTargetClass();
        }
    }

    @Override
    public String getSql() {
        StringBuilder sb = new StringBuilder();
        for (ITextTag text : this.textTag) {
            if (text.isDynamic()) continue;
            if (sb.length() > 0) {
                sb.append(" " + text.getText());
                continue;
            }
            sb.append(text.getText());
        }
        return sb.toString();
    }

    @Override
    public String getSql(Object params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.textTag.size(); ++i) {
            ITextTag tag = this.textTag.get(i);
            boolean result = tag.eval(params);
            if (!result) continue;
            String text = "";
            text = tag.isDynamicGroup() ? tag.getText(params) : tag.getText();
            if (sb.length() > 0) {
                sb.append(" " + text);
                continue;
            }
            sb.append(text);
        }
        String q = sb.toString();
        log.trace("SQL [{}] [{}]:\n{}", new Object[]{this.id, this.languageType, q});
        return q;
    }

    @Override
    public LanguageType getLanguageType() {
        return this.languageType;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public void addTag(ITextTag tag) {
        this.textTag.add(tag);
        if (this.hasParamParser()) {
            return;
        }
        for (ITextTag iTextTag : tag.getTags()) {
            this.setParamParser(iTextTag.getText());
        }
        if (tag instanceof WhereTag && tag.isDynamicGroup()) {
            for (ITextTag iTextTag : tag.getTags()) {
                this.setParamParser(iTextTag.getText());
                for (ITextTag iTextTag2 : iTextTag.getTags()) {
                    this.setParamParser(iTextTag2.getText());
                }
            }
        } else if (!tag.isDynamicGroup()) {
            this.setParamParser(tag.getText());
        }
    }

    @Override
    public void addTag(String text) {
        this.textTag.add(new StaticText(text));
        this.setParamParser(text);
    }

    @Override
    public void addTag(List<ITextTag> tags) {
        for (ITextTag t : tags) {
            this.addTag(t);
        }
    }

    @Override
    public Isolation getIsolation() {
        return this.isolation;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    @Override
    public Selectable asSelectable() {
        throw new UnsupportedOperationException("Isn't Selectable object instance");
    }

    @Override
    public Insertable asInsertable() {
        throw new UnsupportedOperationException("Isn't Insertable object instance");
    }

    @Override
    public Updateable asUpdateable() {
        throw new UnsupportedOperationException("Isn't Updateable object instance");
    }

    @Override
    public Deletable asDeletable() {
        throw new UnsupportedOperationException("Isn't deletable object instance");
    }

    @Override
    public boolean isStorable() {
        return false;
    }

    @Override
    public Storable asStorable() {
        throw new UnsupportedOperationException("Isn't Storable object instance");
    }

    @Override
    public ResultSetType getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(ResultSetType resultSetType) {
        this.resultSetType = resultSetType;
    }

    @Override
    public ResultSetConcurrency getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(ResultSetConcurrency resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    @Override
    public ResultSetHoldability getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(ResultSetHoldability resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public void setResultType(String returnType) {
        this.returnType = returnType;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean hasReturnType() {
        return this.returnType != null && !"".equals(this.returnType.trim());
    }

    @Override
    public Class<?> getReturnTypeAsClass() {
        return this.returnTypeClass;
    }

    @Override
    public void setValidateType(ValidateType validateType) {
        this.validateType = validateType;
    }

    @Override
    public ValidateType getValidateType() {
        return this.validateType;
    }

    @Override
    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public String getXPath() {
        return this.xpath;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public ParamParser getParamParser() {
        return this.paramParser;
    }

    @Override
    public String[] extractNames(Object params) {
        String sql = this.getSql(params);
        return this.paramParser.find(sql);
    }

    @Override
    public String[] extractNames(String sql) {
        return this.paramParser.find(sql);
    }

    @Override
    public void bind(SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    @Override
    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public String getPackage() {
        return this.paket;
    }

    @Override
    public void setPackage(String name) {
        this.paket = name;
    }

    @Override
    public Statistical getStats() {
        return this.stats;
    }

    protected void setStats(Statistical stats) {
        this.stats = stats;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.paket == null ? 0 : this.paket.hashCode());
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSqlTag other = (AbstractSqlTag)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.paket == null ? other.paket != null : !this.paket.equals(other.paket)) {
            return false;
        }
        return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
    }

    private void setParamParser(String text) {
        if (!this.hasParamParser()) {
            if (PATTERN_COLON.matcher(text).find()) {
                this.paramParser = ParamParserFactory.getInstance(ParamMarkType.COLON);
            } else if (PATTERN_HASH.matcher(text).find()) {
                this.paramParser = ParamParserFactory.getInstance(ParamMarkType.HASH);
            } else if (PATTERN_QUESTION.matcher(text).find()) {
                this.paramParser = ParamParserFactory.getInstance(ParamMarkType.QUESTION);
            } else if (PATTERN_DOLLAR.matcher(text).find()) {
                this.paramParser = ParamParserFactory.getInstance(ParamMarkType.DOLLAR);
            }
        }
    }

    private boolean hasParamParser() {
        return !(this.paramParser instanceof ParamParserNoMark);
    }
}

