/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.util;

import java.net.MalformedURLException;
import java.net.URL;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import net.sf.jguard.core.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    private static final String JNDI = "jndi:";
    private static final Logger logger = LoggerFactory.getLogger(ContextUtil.class);
    private static final String SLASH = "/";

    public static URL getContextPath(ServletContext context, String path) {
        URL realPathURL = null;
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        realPathURL = ContextUtil.locatePath(path, context);
        if (realPathURL == null) {
            realPathURL = ContextUtil.locatePath(".", context);
        }
        if (realPathURL != null && realPathURL.toString().startsWith(JNDI) && context.getRealPath(path) != null) {
            try {
                realPathURL = new URL(context.getRealPath(path));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("webappHomePath=" + realPathURL);
        }
        try {
            realPathURL = new URL(XMLUtils.resolveLocation((String)realPathURL.toString()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return realPathURL;
    }

    private static URL locatePath(String path, ServletContext context) {
        URL realPath = null;
        try {
            realPath = context.getResource(path);
        }
        catch (MalformedURLException e) {
            logger.debug(e.getMessage());
        }
        if (realPath == null) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (url == null) {
                logger.error(" resource " + path + " cannot be found \n one solution can be to declare a displayname markup in your web.xml with the name of your war archive ");
                return null;
            }
            realPath = url;
        }
        return realPath;
    }

    public static String getContextPath(PortletContext context, String path) {
        URL realPathURL = null;
        String realPath = null;
        try {
            realPathURL = context.getResource(path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (realPathURL != null) {
            realPath = realPathURL.toString();
        }
        if (realPath == null) {
            realPath = Thread.currentThread().getContextClassLoader().getResource(path).toString();
        }
        if (realPath != null && realPath.startsWith(JNDI) && context.getRealPath(path) != null) {
            realPath = context.getRealPath(path);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("webappHomePath=" + realPath);
        }
        realPath = XMLUtils.resolveLocation((String)realPath);
        return realPath;
    }
}

