/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.taglib;

import com.google.inject.Injector;
import java.security.Permission;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.ConditionalTagSupport;
import javax.servlet.jsp.tagext.Tag;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.jee.authorization.HttpAccessControllerUtils;
import net.sf.jguard.jee.taglib.TagUtils;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasPermission
extends ConditionalTagSupport {
    private static final long serialVersionUID = -2870113702917724315L;
    private final String defaultClassName;
    private String className;
    private String name;
    private String actions;
    private static final Logger logger = LoggerFactory.getLogger(HasPermission.class);
    private Injector injector;

    public HasPermission() {
        this.className = this.defaultClassName = URLPermission.class.getName();
        this.name = "";
        this.actions = "";
    }

    protected boolean condition() throws JspTagException {
        try {
            String csName = (String)ExpressionEvaluatorManager.evaluate((String)"className", (String)this.className, String.class, (Tag)this, (PageContext)this.pageContext);
            this.name = (String)ExpressionEvaluatorManager.evaluate((String)"name", (String)this.name, String.class, (Tag)this, (PageContext)this.pageContext);
            this.actions = (String)ExpressionEvaluatorManager.evaluate((String)"actions", (String)this.actions, String.class, (Tag)this, (PageContext)this.pageContext);
            if (csName != null && !csName.equals("")) {
                this.className = csName;
            }
        }
        catch (JspException e1) {
            throw new JspTagException(e1.getMessage());
        }
        Subject subject = TagUtils.getSubject(this.pageContext);
        if (subject == null) {
            return false;
        }
        Permission permission = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.className);
            permission = net.sf.jguard.core.authorization.Permission.getPermission(clazz, (String)this.name, (String)this.actions);
        }
        catch (ClassNotFoundException e) {
            logger.warn("permission cannot be built ", (Throwable)e);
            throw new JspTagException(e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("permission implementation class=" + permission);
            logger.debug("permission actions=" + this.actions);
        }
        if (this.injector == null) {
            this.injector = (Injector)this.pageContext.getSession().getServletContext().getAttribute(Injector.class.getName());
        }
        HttpAccessControllerUtils httpAccessControllerUtils = (HttpAccessControllerUtils)this.injector.getInstance(HttpAccessControllerUtils.class);
        return httpAccessControllerUtils.hasPermission((HttpServletRequest)this.pageContext.getRequest(), permission);
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

