/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.provisioning;

import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Permissions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.exception.AuthenticationException;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;
import net.sf.jguard.core.principals.SubjectTemplate;
import net.sf.jguard.core.provisioning.ProvisioningServicePoint;
import net.sf.jguard.core.util.CryptUtils;
import net.sf.jguard.core.util.XMLUtils;
import net.sf.jguard.jee.HttpServletRequestAdapter;
import net.sf.jguard.jee.lifecycle.AnonymizerRequestWrapper;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletProvisioningServicePoint
implements ProvisioningServicePoint<HttpServletRequest, HttpServletResponse> {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpServletProvisioningServicePoint.class.getName());
    private String registerURI;
    private URLPermission registerProcessPermission;
    private URLPermission registerPermission;
    private static final String J_GUARD_FILTER_2_0_0_XSD = "jGuardFilter_2.0.0.xsd";
    private AuthenticationManager authenticationManager;

    @Inject
    public HttpServletProvisioningServicePoint(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void init(URL location) {
        this.setSettings(this.loadFilterConfiguration(location));
    }

    public Permission getRegisterPermission() {
        return this.registerPermission;
    }

    public Permission getRegisterProcessPermission() {
        return this.registerProcessPermission;
    }

    public boolean registerProcess(Request<HttpServletRequest> req, Response<HttpServletResponse> res) {
        boolean registerSucceed = this.registerCoreProcess(req);
        HttpServletRequest request = (HttpServletRequest)req.get();
        HttpServletResponse response = (HttpServletResponse)res.get();
        boolean result = false;
        if (!registerSucceed) {
            logger.debug(" registration failed ", (Object)" registerProcess phase ");
            if (!response.isCommitted()) {
                try {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.registerURI));
                }
                catch (IOException e) {
                    logger.warn(" we cannot redirect to " + request.getContextPath() + this.registerURI + " because " + e.getMessage());
                }
            } else {
                logger.warn(" we cannot redirect to " + request.getContextPath() + this.registerURI + " because response is already commited ");
            }
            result = false;
        } else {
            logger.debug(" registration succeed ", (Object)" registerProcess phase ");
            request.getSession(true).removeAttribute("loginContextWrapper");
            request.getSession(true).removeAttribute("lastAccessDeniedPermission");
            result = true;
        }
        return result;
    }

    public boolean registerCoreProcess(Request<HttpServletRequest> req) {
        boolean success;
        HttpServletRequest request = (HttpServletRequest)req.get();
        SubjectTemplate st = null;
        try {
            st = this.buildSubjectTemplate(request);
        }
        catch (AuthenticationException e1) {
            logger.error(" subject template cannot be built ", (Throwable)e1);
            return false;
        }
        String passwordField = "password";
        Set credentials = st.getRequiredCredentials();
        JGuardCredential passwordCredential = null;
        for (JGuardCredential cred : credentials) {
            if (!cred.getName().equals(passwordField)) continue;
            passwordCredential = cred;
            break;
        }
        if (passwordCredential == null) {
            logger.warn("JGuardTagCredential matching  passwordField not found in the SubjectTemplate");
            boolean success2 = false;
            return success2;
        }
        char[] password = passwordCredential.getValue().toString().toCharArray();
        try {
            credentials.remove(passwordCredential);
            credentials.add(new JGuardCredential(passwordCredential.getName(), (Object)CryptUtils.cryptPassword((char[])password).toString()));
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn(ex.getMessage());
            boolean success3 = false;
            return success3;
        }
        try {
            this.authenticationManager.createUser(st, this.authenticationManager.getDefaultOrganization());
            success = true;
        }
        catch (AuthenticationException e) {
            logger.debug(" registrationProcess failed ");
            success = false;
        }
        return success;
    }

    public Request<HttpServletRequest> anonymize(Request<HttpServletRequest> req) {
        HttpServletRequest request = (HttpServletRequest)req.get();
        return new HttpServletRequestAdapter((HttpServletRequest)new AnonymizerRequestWrapper(request));
    }

    private SubjectTemplate buildSubjectTemplate(HttpServletRequest req) throws AuthenticationException {
        SubjectTemplate defaultSt = this.authenticationManager.getDefaultOrganization().getSubjectTemplate();
        SubjectTemplate st = new SubjectTemplate();
        Set privateCredRequiredFromDefaultSt = defaultSt.getPrivateRequiredCredentials();
        Set<JGuardCredential> privRequiredCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, privateCredRequiredFromDefaultSt);
        st.setPrivateRequiredCredentials(privRequiredCred);
        Set publicCredRequiredFromDefaultSt = defaultSt.getPublicRequiredCredentials();
        Set<JGuardCredential> pubRequiredCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, publicCredRequiredFromDefaultSt);
        st.setPublicRequiredCredentials(pubRequiredCred);
        Set publicCredOptionalFromDefaultSt = defaultSt.getPublicOptionalCredentials();
        Set<JGuardCredential> pubOptionalCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, publicCredOptionalFromDefaultSt);
        st.setPublicOptionalCredentials(pubOptionalCred);
        Set privateCredOptionalFromDefaultSt = defaultSt.getPrivateOptionalCredentials();
        Set<JGuardCredential> privOptionalCred = HttpServletProvisioningServicePoint.grabRegistrationForm(req, privateCredOptionalFromDefaultSt);
        st.setPrivateOptionalCredentials(privOptionalCred);
        return st;
    }

    private static Set<JGuardCredential> grabRegistrationForm(HttpServletRequest req, Set credentialsFromDefaultSt) {
        Iterator itCredentials = credentialsFromDefaultSt.iterator();
        HashSet<JGuardCredential> credSet = new HashSet<JGuardCredential>();
        while (itCredentials.hasNext()) {
            JGuardCredential jcredFromDefault = (JGuardCredential)itCredentials.next();
            if (req.getParameter(jcredFromDefault.getName()) == null) continue;
            try {
                JGuardCredential jcred = new JGuardCredential(jcredFromDefault.getName(), (Object)req.getParameter(jcredFromDefault.getName()));
                credSet.add(jcred);
            }
            catch (IllegalArgumentException iae) {
                logger.warn(" the property " + jcredFromDefault.getName() + " doesn't exist in the HttpServletRequest ");
            }
        }
        return credSet;
    }

    private Map<String, String> loadFilterConfiguration(URL configurationLocation) {
        Element passwordElement;
        URL url = Thread.currentThread().getContextClassLoader().getResource(J_GUARD_FILTER_2_0_0_XSD);
        Document doc = XMLUtils.read((URL)configurationLocation, (URL)url);
        Element authentication = doc.getRootElement();
        HashMap<String, String> filterSettings = new HashMap<String, String>();
        if (authentication.element("registerProcessURI") != null) {
            filterSettings.put("registerProcessURI", authentication.element("registerProcessURI").getTextTrim());
        }
        if (authentication.element("registerURI") != null) {
            filterSettings.put("registerURI", authentication.element("registerURI").getTextTrim());
        }
        filterSettings.put("authScheme", authentication.element("authScheme").getTextTrim());
        Element loginElement = authentication.element("loginField");
        if (loginElement != null) {
            filterSettings.put("loginField", loginElement.getTextTrim());
        }
        if ((passwordElement = authentication.element("passwordField")) != null) {
            filterSettings.put("passwordField", passwordElement.getTextTrim());
        }
        return filterSettings;
    }

    private void setSettings(Map<String, String> settings) {
        this.registerProcessPermission = new URLPermission("registerProcessURI", settings.get("registerProcessURI"));
        this.registerURI = settings.get("registerURI");
        this.registerPermission = new URLPermission("registerURI", this.registerURI);
    }

    public Permissions getGrantedPermissions() {
        Permissions alwaysGrantedPermissions = new Permissions();
        alwaysGrantedPermissions.add(this.getRegisterPermission());
        alwaysGrantedPermissions.add(this.getRegisterProcessPermission());
        return alwaysGrantedPermissions;
    }
}

