/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.listeners;

import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import net.sf.jguard.core.authentication.LoginContextWrapperImpl;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.exception.AuthenticationException;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authentication.manager.JGuardAuthenticationManagerMarkups;
import net.sf.jguard.core.util.SubjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAttributeListener
implements HttpSessionAttributeListener {
    public static final Logger logger = LoggerFactory.getLogger(SessionAttributeListener.class);

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (event.getName().equals("loginContextWrapper")) {
            JGuardCredential identity = null;
            try {
                identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is created ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    private JGuardCredential getIdentityCredential(HttpSessionBindingEvent event) throws AuthenticationException {
        Subject subject = ((LoginContextWrapperImpl)event.getValue()).getSubject();
        AuthenticationManager authenticationManager = (AuthenticationManager)event.getSession().getServletContext().getAttribute(JGuardAuthenticationManagerMarkups.AUTHENTICATION_MANAGER.getLabel());
        return SubjectUtils.getIdentityCredential((Subject)subject, (AuthenticationManager)authenticationManager);
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (event.getName().equals("loginContextWrapper")) {
            try {
                JGuardCredential identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is removed ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (event.getName().equals("loginContextWrapper")) {
            try {
                JGuardCredential identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is replaced ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }
}

