/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authorization.http;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.LoginContextWrapperImpl;
import net.sf.jguard.core.authorization.policy.AccessControllerWrapperImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAccessControllerUtils {
    public static final Logger logger = LoggerFactory.getLogger(HttpAccessControllerUtils.class);
    private AccessControllerWrapperImpl accessControlWrapper;

    @Inject
    public HttpAccessControllerUtils(AccessControllerWrapperImpl accessControlWrapper) {
        this.accessControlWrapper = accessControlWrapper;
    }

    public void checkPermission(HttpSession session, Permission p) throws AccessControlException, PrivilegedActionException {
        Subject subject;
        if (session == null) {
            throw new AccessControlException(" user is not yet authenticated ", p);
        }
        LoginContextWrapperImpl authNutils = (LoginContextWrapperImpl)session.getAttribute("loginContextWrapper");
        if (authNutils != null) {
            subject = authNutils.getSubject();
            if (subject == null) {
                throw new AccessControlException(" user is not yet authenticated ", p);
            }
        } else {
            session.removeAttribute("loginContextWrapper");
            throw new AccessControlException(" user is not yet authenticated ", p);
        }
        this.accessControlWrapper.checkPermission(subject, p);
    }

    public boolean hasPermission(HttpServletRequest request, Permission p) {
        boolean result = true;
        try {
            this.checkPermission(request.getSession(true), p);
        }
        catch (AccessControlException ace) {
            logger.debug(ace.getMessage());
            result = false;
        }
        catch (PrivilegedActionException pae) {
            logger.debug(pae.getMessage());
            result = false;
        }
        return result;
    }
}

