/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.schemes;

import java.io.IOException;
import java.security.Permission;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authentication.exception.AuthenticationException;
import net.sf.jguard.core.authentication.schemes.LoginPasswordFormSchemeHandler;
import net.sf.jguard.core.authorization.permissions.PermissionFactory;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;
import net.sf.jguard.core.technology.StatefulScopes;
import net.sf.jguard.jee.HttpPermissionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletLoginPasswordFormSchemeHandler
extends LoginPasswordFormSchemeHandler<HttpServletRequest, HttpServletResponse> {
    private String loginField;
    private String passwordField;
    private String authenticationSucceedURI;
    private String logonProcessURI;
    private Permission logonProcessPermission;
    private String logonURI;
    private Permission logonPermission;
    private String logoffURI;
    private Permission logoffPermission;
    private static final Logger logger = LoggerFactory.getLogger((String)HttpServletLoginPasswordFormSchemeHandler.class.getName());
    private URLPermission authenticationSucceedPermission;
    private URLPermission authenticationFailedPermission;
    public static final String LOGON_PROCESS_URI = "logonProcessURI";
    public static final String LOGIN_FIELD = "loginField";
    public static final String PASSWORD_FIELD = "passwordField";
    public static final String AUTHENTICATION_SUCCEED_URI = "authenticationSucceedURI";
    public static final String AUTHENTICATION_FAILED_URI = "authenticationFailedURI";

    public HttpServletLoginPasswordFormSchemeHandler(Map<String, String> parameters, StatefulScopes authenticationBindings) {
        super(parameters, authenticationBindings);
        this.loginField = parameters.get(LOGIN_FIELD);
        this.passwordField = parameters.get(PASSWORD_FIELD);
        this.authenticationSucceedURI = parameters.get(AUTHENTICATION_SUCCEED_URI);
        if (this.authenticationSucceedURI == null && "".equals(this.authenticationSucceedURI)) {
            throw new IllegalArgumentException("authenticationSucceedURI parameter is null but is required to instantiate HttpServletLoginPasswordFormSchemeHandler");
        }
        this.authenticationSucceedPermission = new URLPermission(AUTHENTICATION_SUCCEED_URI, this.authenticationSucceedURI);
        String authenticationFailedURI = parameters.get(AUTHENTICATION_FAILED_URI);
        if (authenticationFailedURI == null || "".equals(authenticationFailedURI)) {
            throw new IllegalArgumentException("authenticationFailedURI parameter is null but is required to instantiate HttpServletLoginPasswordFormSchemeHandler");
        }
        this.authenticationFailedPermission = new URLPermission(AUTHENTICATION_FAILED_URI, authenticationFailedURI);
        this.logonProcessURI = parameters.get(LOGON_PROCESS_URI);
        if (this.logonProcessURI == null || "".equals(this.logonProcessURI)) {
            throw new IllegalArgumentException("logonProcessURI parameter is null but is required to instantiate HttpServletLoginPasswordFormSchemeHandler");
        }
        this.logonProcessPermission = new URLPermission(LOGON_PROCESS_URI, this.logonProcessURI);
        this.logonURI = parameters.get("logonURI");
        if (this.logonURI == null || "".equals(this.logonURI)) {
            throw new IllegalArgumentException("logonURI parameter is null but is required to instantiate HttpServletLoginPasswordFormSchemeHandler");
        }
        this.logonPermission = new URLPermission("logonURI", this.logonURI);
        this.logoffURI = parameters.get("logoffURI");
        if (this.logoffURI == null || "".equals(this.logoffURI)) {
            throw new IllegalArgumentException("logoffURI parameter is null but is required to instantiate HttpServletLoginPasswordFormSchemeHandler");
        }
        this.logoffPermission = new URLPermission("logoffURI", this.logoffURI);
        this.buildGrantedPermissions();
    }

    protected Permission getLogonProcessPermission() {
        return this.logonProcessPermission;
    }

    public Permission getLogoffPermission() {
        return this.logoffPermission;
    }

    public Permission getLogonPermission() {
        return this.logonPermission;
    }

    protected PermissionFactory<HttpServletRequest> getPermissionFactory() {
        return new HttpPermissionFactory();
    }

    public void buildChallenge(Request<HttpServletRequest> req, Response<HttpServletResponse> res) {
        HttpServletRequest request = (HttpServletRequest)req.get();
        HttpServletResponse response = (HttpServletResponse)res.get();
        if (!response.isCommitted()) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.logonURI));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new AuthenticationException((Throwable)ex);
            }
        }
    }

    public void authenticationSucceed(Subject subject, Request<HttpServletRequest> servletRequest, Response<HttpServletResponse> servletResponse) {
        this.authenticationBindings.setSessionAttribute("redirect", (Object)"true");
        HttpServletRequest request = (HttpServletRequest)servletRequest.get();
        HttpServletResponse response = (HttpServletResponse)servletResponse.get();
        String redirectURI = this.authenticationSucceedURI;
        URLPermission lastAccessDeniedPermission = (URLPermission)this.authenticationBindings.getSessionAttribute("lastAccessDeniedPermission");
        String lastAccessDeniedURI = lastAccessDeniedPermission == null ? this.authenticationSucceedURI : lastAccessDeniedPermission.getURI();
        if (lastAccessDeniedURI != null && !"".equals(lastAccessDeniedURI)) {
            if (this.goToLastAccessDeniedUriOnSuccess) {
                redirectURI = lastAccessDeniedURI;
                request.getSession(true).setAttribute("goToLastAccessDeniedUriOnSuccess", (Object)Boolean.TRUE.toString());
            } else {
                redirectURI = this.logonURI;
            }
        }
        logger.debug(" user is authenticated ", (Object)(" redirect to " + redirectURI));
        if (!response.isCommitted()) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + redirectURI));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new AuthenticationException((Throwable)ex);
            }
        }
    }

    public void authenticationFailed(Request<HttpServletRequest> req, Response<HttpServletResponse> res) {
        this.authenticationBindings.setSessionAttribute("redirect", (Object)"true");
        HttpServletRequest request = (HttpServletRequest)req.get();
        HttpServletResponse response = (HttpServletResponse)res.get();
        if (response.isCommitted()) {
            logger.warn(" response is already committed ");
            return;
        }
        if (this.authenticationFailedPermission != null && !this.authenticationFailedPermission.getURI().equals("")) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.authenticationFailedPermission.getURI()));
                logger.debug("authentication failed redirect to " + this.authenticationFailedPermission.getURI());
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new AuthenticationException((Throwable)ex);
            }
            logger.debug(" user is not authenticated  and redirected to " + request.getContextPath() + this.authenticationFailedPermission.getURI());
        }
    }

    protected String getLogin(Request<HttpServletRequest> req) {
        HttpServletRequest request = (HttpServletRequest)req.get();
        return request.getParameter(this.loginField);
    }

    protected String getPassword(Request<HttpServletRequest> req) {
        HttpServletRequest request = (HttpServletRequest)req.get();
        return request.getParameter(this.passwordField);
    }
}

