/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.schemes;

import java.security.Permission;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authorization.permissions.PermissionFactory;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;
import net.sf.jguard.core.technology.StatefulScopes;
import net.sf.jguard.ext.authentication.schemes.JCaptchaAuthenticationSchemeHandler;
import net.sf.jguard.jee.HttpPermissionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletJcaptchaAuthenticationSchemeHandler
extends JCaptchaAuthenticationSchemeHandler<HttpServletRequest, HttpServletResponse> {
    private static final String LOGON_PROCESS_URI = "logonProcessURI";
    private static final String CAPTCHA_ANSWER_PARAMETER = "captchaAnswerParameter";
    private String captchaAnswerParameter;

    public HttpServletJcaptchaAuthenticationSchemeHandler(Map<String, String> parameters, StatefulScopes authenticationBindings) {
        super(parameters, authenticationBindings);
        String logonProcessURI = parameters.get(LOGON_PROCESS_URI);
        this.logonProcessPermission = new URLPermission(LOGON_PROCESS_URI, logonProcessURI);
        String logonURI = parameters.get("logonURI");
        this.logonPermission = new URLPermission("logonURI", logonURI);
        String logoffURI = parameters.get("logoffURI");
        this.logoffPermission = new URLPermission("logoffURI", logoffURI);
        this.captchaAnswerParameter = parameters.get(CAPTCHA_ANSWER_PARAMETER);
        this.buildGrantedPermissions();
    }

    protected Permission getLogonProcessPermission() {
        return this.logonProcessPermission;
    }

    public Permission getLogoffPermission() {
        return this.logoffPermission;
    }

    public Permission getLogonPermission() {
        return this.logonPermission;
    }

    protected PermissionFactory<HttpServletRequest> getPermissionFactory() {
        return new HttpPermissionFactory();
    }

    public void buildChallenge(Request<HttpServletRequest> request, Response<HttpServletResponse> response) {
    }

    protected String getCaptchaAnswer(Request<HttpServletRequest> request, Response<HttpServletResponse> response) {
        HttpServletRequest req = (HttpServletRequest)request.get();
        return req.getParameter(this.captchaAnswerParameter);
    }

    protected String getSessionID(Request<HttpServletRequest> request) {
        HttpServletRequest req = (HttpServletRequest)request.get();
        return req.getSession(true).getId();
    }
}

