/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.schemes;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import net.sf.jguard.core.authentication.callbacks.InetAddressCallback;
import net.sf.jguard.core.authentication.schemes.AuthenticationSchemeHandler;
import net.sf.jguard.core.authorization.permissions.JGPositivePermissionCollection;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;
import net.sf.jguard.core.technology.StatefulScopes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuditSchemeHandler<Req, Res>
implements AuthenticationSchemeHandler<Req, Res> {
    private List<Class<? extends Callback>> callbackTypes = Arrays.asList(LanguageCallback.class, InetAddressCallback.class);
    private static final Logger logger = LoggerFactory.getLogger(AuditSchemeHandler.class);

    public AuditSchemeHandler(Map<String, String> parameters, StatefulScopes authenticationBindings) {
    }

    public String getName() {
        return "AUDIT";
    }

    public Collection<Class<? extends Callback>> getCallbackTypes() {
        return this.callbackTypes;
    }

    public boolean answerToChallenge(Request request, Response response) {
        return false;
    }

    public boolean challengeNeeded(Request request, Response response) {
        return false;
    }

    public void buildChallenge(Request request, Response response) {
    }

    public PermissionCollection getGrantedPermissions() {
        return new JGPositivePermissionCollection();
    }

    public void authenticationSucceed(Subject subject, Request request, Response response) {
    }

    public void authenticationFailed(Request request, Response response) {
    }

    protected abstract String getRemoteAddress(Request<Req> var1);

    protected abstract String getRemoteHost(Request<Req> var1);

    protected abstract Locale getLocale(Request<Req> var1);

    public void handleSchemeCallbacks(Request<Req> request, Response<Res> response, Callback[] cbks) throws UnsupportedCallbackException {
        for (Callback cb : cbks) {
            if (cb instanceof InetAddressCallback) {
                String remoteAddress = this.getRemoteAddress(request);
                String remoteHost = this.getRemoteHost(request);
                InetAddressCallback inetAddressCallback = (InetAddressCallback)cb;
                inetAddressCallback.setHostAdress(remoteAddress);
                if (remoteAddress == null || !remoteAddress.equals(remoteHost)) continue;
                String resolvedHostName = remoteAddress;
                try {
                    resolvedHostName = AuditSchemeHandler.reverseDns(remoteAddress);
                }
                catch (UnknownHostException uhe) {
                    logger.warn(" host bound to address " + remoteAddress + "cannot be resolved", (Throwable)uhe);
                    throw new UnsupportedCallbackException(cb, uhe.getMessage());
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage());
                    throw new UnsupportedCallbackException(cb, ex.getMessage());
                }
                inetAddressCallback.setHostName(resolvedHostName);
                continue;
            }
            if (!(cb instanceof LanguageCallback)) continue;
            LanguageCallback languageCallback = (LanguageCallback)cb;
            Locale locale = this.getLocale(request);
            languageCallback.setLocale(locale);
        }
    }

    public static String reverseDns(String hostIp) throws IOException {
        int dclass;
        int type;
        ExtendedResolver res = new ExtendedResolver();
        Name name = ReverseMap.fromAddress((String)hostIp);
        Record rec = Record.newRecord((Name)name, (int)(type = 12), (int)(dclass = 1));
        Message query = Message.newQuery((Record)rec);
        Message response = res.send(query);
        Record[] answers = response.getSectionArray(1);
        if (answers.length == 0) {
            return hostIp;
        }
        return answers[0].rdataToString();
    }
}

