/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import com.octo.captcha.module.config.CaptchaModuleConfig;
import com.octo.captcha.service.AbstractManageableCaptchaService;
import com.octo.captcha.service.CaptchaService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaChallengeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CaptchaChallengeBuilder.class);
    private static final String JPEG_FORMAT_NAME = "JPEG";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String NO_STORE = "no-store";
    private static final String PRAGMA = "Pragma";
    private static final String NO_CACHE = "no-cache";
    private static final String EXPIRES = "Expires";
    private static final String IMAGE_JPEG = "image/jpeg";

    public static void buildCaptchaChallenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        CaptchaService service = (CaptchaService)session.getServletContext().getAttribute("captchaService");
        if (service == null) {
            logger.debug("captcha service should be defined ");
            try {
                service = (CaptchaService)Thread.currentThread().getContextClassLoader().loadClass(CaptchaModuleConfig.getInstance().getServiceClass()).newInstance();
                session.getServletContext().setAttribute("captchaService", (Object)service);
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
            }
            if (service != null) {
                logger.debug(" CAPTCHA SERVICE=" + service.getClass().getName() + " will be defined");
                if (service.getClass().isAssignableFrom(AbstractManageableCaptchaService.class)) {
                    ((AbstractManageableCaptchaService)service).emptyCaptchaStore();
                }
            }
        } else {
            logger.debug(" CAPTCHA SERVICE=" + service.getClass().getName());
        }
        byte[] captchaChallengeAsJpeg = CaptchaChallengeBuilder.buildCaptchaChallenge(session.getId(), request.getLocale(), service);
        response.setHeader(CACHE_CONTROL, NO_STORE);
        response.setHeader(PRAGMA, NO_CACHE);
        response.setDateHeader(EXPIRES, 0L);
        response.setContentType(IMAGE_JPEG);
        try {
            ServletOutputStream responseOutputStream = response.getOutputStream();
            responseOutputStream.write(captchaChallengeAsJpeg);
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (IOException e) {
            logger.error(" captcha cannot be generated", (Throwable)e);
        }
    }

    private static byte[] buildCaptchaChallenge(String captchaId, Locale locale, CaptchaService service) throws IOException {
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        logger.debug("sessionID=" + captchaId);
        BufferedImage challenge = (BufferedImage)service.getChallengeForID(captchaId, locale);
        logger.debug("challenge=" + service.getQuestionForID(captchaId, locale));
        logger.debug(" service=" + service);
        ImageIO.write((RenderedImage)challenge, JPEG_FORMAT_NAME, jpegOutputStream);
        byte[] captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        return captchaChallengeAsJpeg;
    }
}

