/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.filters;

import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AuthenticationServicePoint;
import net.sf.jguard.core.authentication.LoginContextWrapper;
import net.sf.jguard.core.authentication.filters.AuthenticationFilter;
import net.sf.jguard.core.enforcement.GuestPolicyEnforcementPointFilter;
import net.sf.jguard.core.enforcement.StatefulAuthenticationFiltersProvider;
import net.sf.jguard.core.filters.FilterChain;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletStatefulAuthenticationFiltersProvider
extends StatefulAuthenticationFiltersProvider<HttpServletRequest, HttpServletResponse> {
    @Inject
    public HttpServletStatefulAuthenticationFiltersProvider(Request<HttpServletRequest> request, Response<HttpServletResponse> response, AuthenticationServicePoint<HttpServletRequest, HttpServletResponse> authenticationServicePoint, List<AuthenticationFilter<HttpServletRequest, HttpServletResponse>> authenticationFilters, GuestPolicyEnforcementPointFilter<HttpServletRequest, HttpServletResponse> guestPolicyEnforcementPointFilter) {
        super(request, response, authenticationServicePoint, authenticationFilters, guestPolicyEnforcementPointFilter, (AuthenticationFilter)new AuthenticationFilter<HttpServletRequest, HttpServletResponse>(){

            public void doFilter(Request<HttpServletRequest> request, Response<HttpServletResponse> response, FilterChain<HttpServletRequest, HttpServletResponse> chain) {
                LoginContextWrapper wrapper = (LoginContextWrapper)((HttpServletRequest)request.get()).getSession(true).getAttribute("loginContextWrapper");
                if (null == wrapper || null == wrapper.getSubject()) {
                    throw new IllegalArgumentException("loginContext is null");
                }
                this.propagateWithSecurity(wrapper.getSubject(), request, response, chain);
            }
        });
    }

    protected boolean alreadyAuthenticated(Request<HttpServletRequest> request) {
        HttpSession session = ((HttpServletRequest)request.get()).getSession(true);
        LoginContextWrapper wrapper = (LoginContextWrapper)session.getAttribute("loginContextWrapper");
        return null != wrapper;
    }
}

