/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee;

import java.security.Permission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sf.jguard.core.authorization.permissions.PermissionFactory;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.core.lifecycle.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPermissionFactory
implements PermissionFactory<HttpServletRequest> {
    public static final Logger logger = LoggerFactory.getLogger(HttpPermissionFactory.class);
    private static Pattern starPattern = Pattern.compile("\\*");
    private static final String STAR = "\\*";
    private static final String DOUBLE_STAR = "\\*\\*";
    private static final String PERMISSION_FROM_USER_GENERIC_PERMISSION_NAME = "permissionFromUser";

    public Permission getPermission(Request<HttpServletRequest> requestAdapter) {
        HttpServletRequest request = (HttpServletRequest)requestAdapter.get();
        String uriWithQuery = HttpPermissionFactory.buildRequest(request);
        logger.debug("uriWithQuery=" + uriWithQuery);
        StringBuffer actions = new StringBuffer(URLPermission.removeRegexpFromURI((String)uriWithQuery));
        actions.append(',').append(request.getProtocol()).append(',').append(request.getMethod()).append("permission build from the user request");
        return new URLPermission(PERMISSION_FROM_USER_GENERIC_PERMISSION_NAME, actions.toString());
    }

    private static String buildRequest(HttpServletRequest req) {
        String servletPath;
        String uri = req.getRequestURI();
        int index = uri.indexOf(servletPath = req.getServletPath());
        if (-1 == index) {
            throw new IllegalArgumentException("uri does not contains servletPath");
        }
        StringBuffer sb = new StringBuffer(uri.substring(index));
        if (req.getQueryString() != null && req.getQueryString().length() > 0) {
            sb.append("?");
            sb.append(req.getQueryString());
        }
        String uriWithQuery = sb.toString();
        Matcher matcher = starPattern.matcher(uriWithQuery);
        uriWithQuery = matcher.replaceAll(DOUBLE_STAR);
        logger.debug("uriWithQuery=" + uriWithQuery);
        return uriWithQuery;
    }
}

