/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.taglib;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.jee.HttpConstants;
import net.sf.jguard.jee.taglib.TagUtils;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JGuardTagCredential
extends TagSupport
implements HttpConstants {
    protected String id = "";
    protected String def;
    private static final Logger logger = LoggerFactory.getLogger(JGuardTagCredential.class);
    private String visibility = this.isPrivate() ? "private" : "public";

    protected abstract Set<JGuardCredential> getCredentials(Subject var1);

    protected abstract boolean isPrivate();

    protected abstract String getTagName();

    public int doEndTag() throws JspException {
        String name;
        String defaut;
        String value;
        block11: {
            value = null;
            defaut = (String)ExpressionEvaluatorManager.evaluate((String)"default", (String)this.def, String.class, (Tag)this, (PageContext)this.pageContext);
            name = (String)ExpressionEvaluatorManager.evaluate((String)"id", (String)this.id, String.class, (Tag)this, (PageContext)this.pageContext);
            Subject subject = TagUtils.getSubject(this.pageContext);
            try {
                if (subject == null) break block11;
                Set<JGuardCredential> credentials = this.getCredentials(subject);
                Iterator<JGuardCredential> it = credentials.iterator();
                JGuardCredential cred = null;
                while (it.hasNext()) {
                    cred = it.next();
                    if (!cred.getName().equals(name)) continue;
                    value = cred.getValue().toString();
                    break;
                }
            }
            catch (SecurityException sex) {
                if (logger.isErrorEnabled()) {
                    logger.error("doEndTag() - you don't have the permission to access to the " + this.visibility + " credentialsn");
                }
                if (logger.isErrorEnabled()) {
                    logger.error("doEndTag() - you should contact your administrator server n ");
                }
                value = "you don't have the permission to access to the " + this.visibility + " credentials";
            }
        }
        if (value == null && defaut != null) {
            value = defaut;
        } else if (name == null) {
            value = "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<jguard:" + this.getTagName() + "> id=" + this.id);
            logger.debug("<jguard:" + this.getTagName() + "> default=" + defaut);
            logger.debug("<jguard:" + this.getTagName() + "> value=" + value);
        }
        try {
            this.pageContext.getOut().print(value);
        }
        catch (IOException e) {
            logger.error("doEndTag()", (Throwable)e);
        }
        return 6;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDefault() {
        return this.def;
    }

    public void setDefault(String def) {
        this.def = def;
    }
}

