/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.listeners;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Policy;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import net.sf.jguard.core.FilterChainModule;
import net.sf.jguard.core.authentication.AuthenticationModule;
import net.sf.jguard.core.authentication.AuthenticationScope;
import net.sf.jguard.core.authentication.manager.AuthenticationManagerModule;
import net.sf.jguard.core.authorization.AuthorizationModule;
import net.sf.jguard.core.authorization.AuthorizationScope;
import net.sf.jguard.core.authorization.manager.AuthorizationManager;
import net.sf.jguard.core.authorization.policy.MultipleAppPolicy;
import net.sf.jguard.core.jmx.JMXModule;
import net.sf.jguard.core.jmx.JMXParameters;
import net.sf.jguard.ext.authentication.manager.XmlAuthenticationManager;
import net.sf.jguard.ext.authorization.manager.XmlAuthorizationManager;
import net.sf.jguard.jee.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextListener
extends GuiceServletContextListener {
    protected Injector injector;
    private static final Logger logger = LoggerFactory.getLogger(ContextListener.class);
    private static final String SLASH = "/";
    private Class<? extends AuthorizationManager> authorizationManagerClass = XmlAuthorizationManager.class;
    private String applicationName;
    private URL authenticationXmlFileLocation;
    private URL filterConfigurationLocation;
    private AuthenticationScope authenticationScope = AuthenticationScope.LOCAL;
    private boolean propagateThrowable = false;
    private URL applicationPath;
    private URL authenticationConfigurationURL;
    private URL authorizationConfigurationURL;
    private String rmiRegistryHost;
    private int rmiRegistryPort;
    private String mbeanServerForConnector;
    private boolean enableJMX;
    private static String defaultConfigurationDirectoryValue = "/WEB-INF/conf/jGuard/";
    private static final String J_GUARD_USERS_PRINCIPALS_XML = "jGuardUsersPrincipals.xml";
    private static final String J_GUARD_FILTER_XML = "jGuardFilter.xml";
    public static final String FILTER_LOCATION = "filterLocation";
    private static final String APPLICATION_NAME_IS_MISSING = " ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ";
    private static final String INIT_PARAMETER_IS_NULL = " init parameter is null";
    private static final String CONFIGURATION_DIRECTORY = "configurationDirectory";
    private static final String DEFAULT_CONFIGURATION_DIRECTORY = "defaultConfigurationDirectory";

    public void contextInitialized(ServletContextEvent contextEvent) {
        logger.debug("#####  initializing ContextListener ... #####");
        ServletContext context = contextEvent.getServletContext();
        this.applicationPath = ContextUtil.getContextPath(context, SLASH);
        this.applicationName = context.getServletContextName();
        if (this.applicationName.startsWith(SLASH)) {
            this.applicationName = this.applicationName.replaceFirst(SLASH, "");
        }
        if (this.applicationName == null) {
            logger.error(APPLICATION_NAME_IS_MISSING);
            throw new IllegalStateException(APPLICATION_NAME_IS_MISSING);
        }
        if (!defaultConfigurationDirectoryValue.endsWith(SLASH)) {
            defaultConfigurationDirectoryValue = defaultConfigurationDirectoryValue + SLASH;
        }
        this.filterConfigurationLocation = this.getLocation(FILTER_LOCATION, defaultConfigurationDirectoryValue + J_GUARD_FILTER_XML, context);
        if (this.filterConfigurationLocation == null) {
            throw new IllegalArgumentException("filterLocation init parameter is null");
        }
        this.checkFileExists(this.filterConfigurationLocation);
        this.authenticationXmlFileLocation = this.getLocation("authenticationXmlFileLocation", defaultConfigurationDirectoryValue + J_GUARD_USERS_PRINCIPALS_XML, context);
        if (this.authenticationXmlFileLocation == null) {
            throw new IllegalArgumentException("authenticationXmlFileLocation init parameter is null");
        }
        this.checkFileExists(this.authenticationXmlFileLocation);
        this.authorizationConfigurationURL = this.getLocation("authorizationConfigurationLocation", "/WEB-INF/conf/jGuard/jGuardAuthorization.xml", context);
        if (this.authorizationConfigurationURL == null) {
            throw new IllegalArgumentException("authorizationConfigurationLocation init parameter is null");
        }
        this.checkFileExists(this.authorizationConfigurationURL);
        this.authenticationConfigurationURL = this.getLocation("authenticationConfigurationLocation", "/WEB-INF/conf/jGuard/jGuardAuthentication.xml", context);
        if (this.authenticationConfigurationURL == null) {
            throw new IllegalArgumentException("authenticationConfigurationLocation init parameter is null");
        }
        this.checkFileExists(this.authenticationConfigurationURL);
        this.rmiRegistryHost = JMXParameters.DEFAULT_RMI_REGISTRY_HOST.getLabel();
        if (context.getInitParameter(JMXParameters.RMI_REGISTRY_HOST.getLabel()) != null) {
            this.rmiRegistryHost = context.getInitParameter(JMXParameters.RMI_REGISTRY_HOST.getLabel());
        }
        this.rmiRegistryPort = JMXParameters.DEFAULT_RMI_REGISTRY_PORT.getValue();
        if (context.getInitParameter(JMXParameters.RMI_REGISTRY_PORT.getLabel()) != null) {
            this.rmiRegistryPort = Integer.parseInt(context.getInitParameter(JMXParameters.RMI_REGISTRY_PORT.getLabel()));
        }
        this.mbeanServerForConnector = context.getInitParameter(JMXParameters.MBEAN_SERVER_FOR_CONNECTOR.getLabel());
        this.enableJMX = Boolean.parseBoolean(context.getInitParameter(JMXParameters.MBEAN_SERVER_FOR_CONNECTOR.getLabel()));
        this.injector = this.getInjector();
        context.setAttribute(Injector.class.getName(), (Object)this.injector);
        logger.debug("#####  ContextListener initialized  #####");
    }

    private void checkFileExists(URL filterConfigurationLocation) {
        try {
            File filterConfigurationFile = new File(filterConfigurationLocation.toURI());
            if (!filterConfigurationFile.exists() || filterConfigurationFile.isDirectory()) {
                logger.error("configuration url =" + filterConfigurationLocation + "does not point to a config file");
                throw new IllegalStateException("configuration url =" + filterConfigurationLocation + "does not point to a config file");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.debug(" context destroyed ");
        ServletContext context = servletContextEvent.getServletContext();
        context.removeAttribute(Injector.class.getName());
        super.contextDestroyed(servletContextEvent);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (Policy.getPolicy() instanceof MultipleAppPolicy) {
            MultipleAppPolicy policy = (MultipleAppPolicy)Policy.getPolicy();
            policy.unregisterPermissionProvider((Object)contextClassLoader);
        }
        context.removeAttribute("captchaService");
    }

    private URL getLocation(String initParameterName, String defaultLocation, ServletContext context) {
        URL location = context.getInitParameter(initParameterName) != null ? ContextUtil.getContextPath(context, context.getInitParameter(initParameterName)) : ContextUtil.getContextPath(context, defaultLocation);
        return location;
    }

    protected Injector getInjector() {
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add(this.getServletModule());
        modules.add(new AuthenticationManagerModule(this.applicationName, this.authenticationXmlFileLocation, XmlAuthenticationManager.class));
        modules.add(new FilterChainModule(this.propagateThrowable));
        modules.add(new AuthenticationModule(this.authenticationScope, this.authenticationConfigurationURL, this.filterConfigurationLocation));
        modules.add(new AuthorizationModule(AuthorizationScope.LOCAL, this.authorizationManagerClass, this.authorizationConfigurationURL, this.applicationPath));
        modules.add(this.getTechnologySpecificModule());
        if (this.enableJMX) {
            modules.add(new JMXModule(this.rmiRegistryHost, this.rmiRegistryPort));
        }
        this.injector = Guice.createInjector(modules);
        return this.injector;
    }

    public abstract ServletModule getServletModule();

    public abstract Module getTechnologySpecificModule();
}

