/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authorization;

import com.google.inject.Inject;
import java.io.IOException;
import java.security.Permission;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authentication.exception.AuthenticationException;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.authorization.permissions.PermissionFactory;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;
import net.sf.jguard.core.technology.StatefulScopes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletAuthorizationBindings
implements AuthorizationBindings<HttpServletRequest, HttpServletResponse> {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpServletAuthorizationBindings.class.getName());
    private PermissionFactory<HttpServletRequest> permissionFactory;
    private StatefulScopes scopes;
    public static final String POST_AUTHENTICATION_PERMISSION = "postAuthenticationPermission";

    @Inject
    public HttpServletAuthorizationBindings(PermissionFactory<HttpServletRequest> permissionFactory, StatefulScopes scopes) {
        this.permissionFactory = permissionFactory;
        this.scopes = scopes;
    }

    public Permission getPermissionRequested(Request<HttpServletRequest> request) {
        return this.permissionFactory.getPermission(request);
    }

    public void setLastAccessDeniedPermission(Request<HttpServletRequest> request, Permission permission) {
        this.scopes.setSessionAttribute("lastAccessDeniedPermission", (Object)permission);
    }

    public Permission getPostAuthenticationPermission(Request<HttpServletRequest> httpServletRequestRequest) {
        return (Permission)this.scopes.getSessionAttribute(POST_AUTHENTICATION_PERMISSION);
    }

    public void accessDenied(Request<HttpServletRequest> request, Response<HttpServletResponse> response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.get();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.get();
        if (logger.isDebugEnabled()) {
            logger.debug(" access denied to " + httpServletRequest.getRequestURI());
        }
        logger.debug(" access is denied to " + httpServletRequest.getRequestURI() + " jGuard send 403 http code ");
        httpServletResponse.setStatus(403);
        try {
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(403, "access is denied to " + httpServletRequest.getRequestURI());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void handlePermission(Request<HttpServletRequest> request, Response<HttpServletResponse> response, Permission permission) {
        if (permission.getClass().isAssignableFrom(URLPermission.class)) {
            URLPermission urlPermission = (URLPermission)permission;
            String uri = urlPermission.getURI();
            try {
                ((HttpServletResponse)response.get()).sendRedirect(((HttpServletResponse)response.get()).encodeRedirectURL(((HttpServletRequest)request.get()).getContextPath() + uri));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new AuthenticationException((Throwable)ex);
            }
        }
    }
}

