/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sf.jguard.core.ApplicationName;
import net.sf.jguard.core.authentication.LoginContextWrapper;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.jee.authentication.http.JEERequestWrapperUtil;

@RequestScoped
public class JGuardServletRequestWrapper
extends HttpServletRequestWrapper {
    private Map headers = null;
    private String applicationName;
    private AuthenticationManager authenticationManager;
    private HttpServletRequest request;
    private LoginContextWrapper loginContextWrapper;

    @Inject
    public JGuardServletRequestWrapper(@ApplicationName String applicationName, AuthenticationManager authenticationManager, HttpServletRequest req, LoginContextWrapper loginContextWrapper) {
        super(req);
        this.applicationName = applicationName;
        this.authenticationManager = authenticationManager;
        this.request = req;
        this.loginContextWrapper = loginContextWrapper;
        this.headers = new HashMap();
    }

    public boolean isUserInRole(String role) {
        return JEERequestWrapperUtil.isUserInRole(this.applicationName, role, this.loginContextWrapper);
    }

    public Principal getUserPrincipal() {
        LoginContextWrapper loginContextWrapperImpl = (LoginContextWrapper)this.request.getSession(true).getAttribute("loginContextWrapper");
        return JEERequestWrapperUtil.getUserPrincipal(loginContextWrapperImpl);
    }

    public String getRemoteUser() {
        LoginContextWrapper loginContextWrapperImpl = (LoginContextWrapper)this.request.getSession(true).getAttribute("loginContextWrapper");
        if (this.authenticationManager == null) {
            return null;
        }
        return JEERequestWrapperUtil.getRemoteUser(loginContextWrapperImpl, this.authenticationManager);
    }

    public void setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public String getHeader(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return (String)this.headers.get(headerName);
        }
        return super.getHeader(headerName);
    }
}

