/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;
import net.sf.jguard.core.technology.AbstractScopes;
import net.sf.jguard.core.technology.StatefulScopes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class HttpServletScopes
extends AbstractScopes<HttpServletRequest, HttpServletResponse>
implements StatefulScopes {
    @Inject
    public HttpServletScopes(Request<HttpServletRequest> request, Response<HttpServletResponse> response) {
        super(request, response);
    }

    public Object getSessionAttribute(String key) {
        HttpSession session = this.getSession(true);
        return session.getAttribute(key);
    }

    public Iterator<String> getSessionAttributeNames() {
        return Collections.list(this.getSession(true).getAttributeNames()).iterator();
    }

    public void setSessionAttribute(String key, Object value) {
        HttpSession session = this.getSession(true);
        session.setAttribute(key, value);
    }

    public void removeSessionAttribute(String key) {
        HttpSession session = this.getSession(true);
        session.removeAttribute(key);
    }

    public void removeApplicationAttribute(String key) {
        ServletContext servletContext = ((HttpServletRequest)this.request.get()).getSession(true).getServletContext();
        servletContext.removeAttribute(key);
    }

    public void removeRequestAttribute(String key) {
        ((HttpServletRequest)this.request.get()).removeAttribute(key);
    }

    public void setRequestAttribute(String key, Object value) {
        ((HttpServletRequest)this.request.get()).setAttribute(key, value);
    }

    public void setApplicationAttribute(String key, Object value) {
        ServletContext servletContext = this.getServletContext();
        if (servletContext == null) {
            throw new IllegalStateException(" servletContext is null");
        }
        servletContext.setAttribute(key, value);
    }

    public Object getRequestAttribute(String key) {
        return ((HttpServletRequest)this.request.get()).getAttribute(key);
    }

    public Object getApplicationAttribute(String key) {
        ServletContext servletContext = this.getServletContext();
        if (servletContext == null) {
            return null;
        }
        return servletContext.getAttribute(key);
    }

    public void invalidateSession() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    private ServletContext getServletContext() {
        ServletContext servletContext = ((HttpServletRequest)this.request.get()).getSession(true).getServletContext();
        return servletContext;
    }

    private HttpSession getSession(boolean createSession) {
        return ((HttpServletRequest)this.request.get()).getSession(createSession);
    }

    public String getInitApplicationAttribute(String key) {
        return this.getServletContext().getInitParameter(key);
    }
}

