/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Policy;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.PolicyEnforcementPointOptions;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.enforcement.EntryPoint;
import net.sf.jguard.core.enforcement.PolicyEnforcementPoint;
import net.sf.jguard.core.lifecycle.Request;
import net.sf.jguard.core.lifecycle.Response;
import net.sf.jguard.jee.provisioning.HttpServletProvisioningServicePoint;
import net.sf.jguard.jee.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AccessFilter
implements Filter,
EntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(AccessFilter.class);
    private Injector injector;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.injector = (Injector)filterConfig.getServletContext().getAttribute(Injector.class.getName());
        if (null == this.injector) {
            throw new IllegalArgumentException("Guice injector has not been properly initialized by ContextListener and put in the servlet context");
        }
        this.injector.injectMembers((Object)this);
        logger.debug("server info = " + filterConfig.getServletContext().getServerInfo());
        logger.debug("servletContextName=" + filterConfig.getServletContext().getServletContextName());
        logger.debug("servlet Real Path=" + ContextUtil.getContextPath(filterConfig.getServletContext(), "/"));
        logger.debug("current Policy=" + Policy.getPolicy().getClass().getName());
        ServletContext context = filterConfig.getServletContext();
        String provisioningServicePointImpl = context.getInitParameter(PolicyEnforcementPointOptions.PROVISIONING_SERVICE_POINT.getLabel());
        if (provisioningServicePointImpl == null || provisioningServicePointImpl.equals("")) {
            logger.info(PolicyEnforcementPointOptions.PROVISIONING_SERVICE_POINT.getLabel() + " is null default settings is " + HttpServletProvisioningServicePoint.class.getName());
        }
        boolean propagateThrowableOption = false;
        String propagateThrowable = context.getInitParameter(PolicyEnforcementPointOptions.PROPAGATE_THROWABLE.getLabel());
        if (propagateThrowable != null && !"".equals(propagateThrowable)) {
            propagateThrowableOption = Boolean.parseBoolean(propagateThrowable);
        } else {
            logger.info(PolicyEnforcementPointOptions.PROPAGATE_THROWABLE + " is not defined default setting " + propagateThrowableOption + " is set");
        }
        logger.info("propagateThrowable=" + propagateThrowable);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AuthorizationBindings authorizationBindings = null;
        Request request = null;
        Response response = null;
        try {
            PolicyEnforcementPoint pep = (PolicyEnforcementPoint)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<PolicyEnforcementPoint<HttpServletRequest, HttpServletResponse>>(){}));
            request = (Request)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Request<HttpServletRequest>>(){}));
            response = (Response)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Response<HttpServletResponse>>(){}));
            authorizationBindings = (AuthorizationBindings)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<AuthorizationBindings<HttpServletRequest, HttpServletResponse>>(){}));
            pep.doFilter(request, response);
        }
        catch (AccessControlException ace) {
            authorizationBindings.accessDenied(request, response);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (!servletResponse.isCommitted()) {
                ((HttpServletResponse)servletResponse).sendError(500);
            }
            logger.error("reponse is already committed. we cannot send an 'internal server error' code (500) ");
        }
    }

    public void destroy() {
    }

    public Injector getInjector() {
        return this.injector;
    }
}

