/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authentication.Stateful;
import net.sf.jguard.core.authentication.filters.AuthenticationFilter;
import net.sf.jguard.core.authorization.filters.AuthorizationFilter;
import net.sf.jguard.core.enforcement.PolicyEnforcementPoint;
import net.sf.jguard.core.lifecycle.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class HttpServletPolicyEnforcementPoint
extends PolicyEnforcementPoint<HttpServletRequest, HttpServletResponse> {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpServletPolicyEnforcementPoint.class.getName());

    @Inject
    public HttpServletPolicyEnforcementPoint(@Stateful List<AuthenticationFilter<HttpServletRequest, HttpServletResponse>> authenticationFilters, List<AuthorizationFilter<HttpServletRequest, HttpServletResponse>> authorizationFilters, boolean propagateThrowable) {
        super(authenticationFilters, authorizationFilters, propagateThrowable);
    }

    protected void sendThrowable(Response<HttpServletResponse> response, Throwable throwable) {
        logger.error(throwable.getMessage(), throwable);
        HttpServletResponse res = (HttpServletResponse)response.get();
        try {
            res.sendError(500);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

