/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.taglib;

import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.LoopTagSupport;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.jee.taglib.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Principals
extends LoopTagSupport {
    private static final Logger logger = LoggerFactory.getLogger(Principals.class);
    private static final long serialVersionUID = 5869136846797237440L;
    private static final Class defaultClassName = RolePrincipal.class;
    private Class clazz = defaultClassName;
    private Iterator principalsIt;

    public final void setClassName(String className) {
        try {
            this.clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.info(" 'className' attribute does not map to an existing or reachable class ");
        }
    }

    protected boolean hasNext() throws JspTagException {
        return this.principalsIt.hasNext();
    }

    protected Object next() throws JspTagException {
        return this.principalsIt.next();
    }

    protected void prepare() throws JspTagException {
        Set principals;
        Subject subject = TagUtils.getSubject(this.pageContext);
        if (subject == null) {
            subject = new Subject();
        }
        if ((principals = subject.getPrincipals(this.clazz)) == null) {
            throw new JspTagException("principal's set is null ");
        }
        this.principalsIt = principals.iterator();
    }
}

