/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.taglib;

import java.security.Permission;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.ConditionalTagSupport;
import javax.servlet.jsp.tagext.Tag;
import net.sf.jguard.core.authorization.permissions.PermissionUtils;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.jee.authorization.http.HttpAccessControllerUtils;
import net.sf.jguard.jee.taglib.TagUtils;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authorized
extends ConditionalTagSupport {
    private static final Logger logger = LoggerFactory.getLogger(Authorized.class);
    private static final long serialVersionUID = 3833742183621736755L;
    private String uri;
    private String permission = URLPermission.class.getName();

    public String getUri() {
        return this.uri;
    }

    public void setUri(String strUri) {
        this.uri = strUri;
    }

    protected boolean condition() throws JspTagException {
        Subject subject;
        try {
            this.uri = (String)ExpressionEvaluatorManager.evaluate((String)"uri", (String)this.uri, String.class, (Tag)this, (PageContext)this.pageContext);
            String perm = (String)ExpressionEvaluatorManager.evaluate((String)"permission", (String)this.permission, String.class, (Tag)this, (PageContext)this.pageContext);
            if (perm != null && !perm.equals("")) {
                this.permission = perm;
            }
        }
        catch (JspException e1) {
            logger.error("condition()", (Throwable)e1);
            throw new JspTagException(e1.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<jguard:authorized> tag uri=" + this.uri);
        }
        if ((subject = TagUtils.getSubject(this.pageContext)) == null) {
            return false;
        }
        StringBuffer actions = new StringBuffer();
        actions.append(this.uri);
        Permission urlPermission = null;
        try {
            urlPermission = PermissionUtils.getPermission((String)this.permission, (String)"dummy name", (String)actions.toString());
        }
        catch (ClassNotFoundException e) {
            logger.warn("permission cannot be built ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("permission implementation class=" + this.permission);
            logger.debug("permission actions=" + actions.toString());
            logger.debug("URLPermission=" + urlPermission);
        }
        return HttpAccessControllerUtils.hasPermission((HttpServletRequest)this.pageContext.getRequest(), urlPermission);
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }
}

