/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.listeners;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionListener
implements HttpSessionListener {
    public static final Logger logger = LoggerFactory.getLogger(SessionListener.class);

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        if (session != null) {
            try {
                AuthenticationUtils authUtils = (AuthenticationUtils)session.getAttribute("authenticationUtils");
                if (authUtils != null) {
                    authUtils.logout();
                }
                session.removeAttribute("authenticationUtils");
            }
            catch (IllegalStateException ise) {
                logger.debug(" session is already invalidated ");
            }
        }
    }
}

