/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.listeners;

import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.ext.util.SubjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAttributeListener
implements HttpSessionAttributeListener {
    public static final Logger logger = LoggerFactory.getLogger(SessionAttributeListener.class);

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (event.getName().equals("authenticationUtils")) {
            JGuardCredential identity = null;
            try {
                identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is created ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    private JGuardCredential getIdentityCredential(HttpSessionBindingEvent event) throws AuthenticationException {
        Subject subject = ((AuthenticationUtils)event.getValue()).getSubject();
        JGuardCredential identity = SubjectUtils.getIdentityCredential((Subject)subject, (AuthenticationManager)AuthenticationManagerFactory.getAuthenticationManager());
        return identity;
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (event.getName().equals("authenticationUtils")) {
            JGuardCredential identity = null;
            try {
                identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is removed ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (event.getName().equals("authenticationUtils")) {
            JGuardCredential identity = null;
            try {
                identity = this.getIdentityCredential(event);
                logger.info("subject with identityCredential=" + identity + " is replaced ");
            }
            catch (AuthenticationException ex) {
                logger.warn(ex.getMessage());
            }
        }
    }
}

