/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.listeners;

import java.security.Policy;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authorization.policy.MultipleAppPolicy;
import net.sf.jguard.ext.InitHelper;
import net.sf.jguard.jee.authentication.http.HttpServletAuthenticationBindingsFactory;
import net.sf.jguard.jee.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ContextListener.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.debug(" context destroyed ");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (Policy.getPolicy() instanceof MultipleAppPolicy) {
            MultipleAppPolicy policy = (MultipleAppPolicy)Policy.getPolicy();
            policy.unregisterPermissionProvider((Object)contextClassLoader);
        }
        servletContextEvent.getServletContext().removeAttribute("captchaService");
        servletContextEvent.getServletContext().removeAttribute("sessionList");
    }

    public void contextInitialized(ServletContextEvent contextEvent) {
        logger.debug("#####  initializing ContextListener ... #####");
        ServletContext context = contextEvent.getServletContext();
        context.setAttribute("sessionList", new ArrayList());
        String webappHomePath = ContextUtil.getContextPath(context, "/");
        if (!webappHomePath.endsWith("/")) {
            webappHomePath = webappHomePath + "/";
        }
        String applicationName = context.getServletContextName();
        String authorizationConfigurationLocation = this.getAuthorizationConfigurationLocation(context);
        String authenticationConfigurationLocation = this.getAuthenticationConfigurationLocation(context);
        AccessContext accessContext = new AccessContext();
        accessContext.setAttribute("servletContext", (Object)context);
        String authFactoryClass = HttpServletAuthenticationBindingsFactory.class.getName();
        InitHelper.installAuthorizationAndAuthentication((String)authorizationConfigurationLocation, (String)webappHomePath, (String)authFactoryClass, (AccessContext)accessContext, (String)applicationName, (String)authenticationConfigurationLocation);
        logger.debug("#####  ContextListener initialized  #####");
    }

    private String getAuthorizationConfigurationLocation(ServletContext context) {
        String authorizationConfigurationLocation = null;
        authorizationConfigurationLocation = context.getInitParameter("authorizationConfigurationLocation") != null ? ContextUtil.getContextPath(context, context.getInitParameter("authorizationConfigurationLocation")) : ContextUtil.getContextPath(context, "/WEB-INF/conf/jGuard/jGuardAuthorization.xml");
        return authorizationConfigurationLocation;
    }

    private String getAuthenticationConfigurationLocation(ServletContext context) {
        String authenticationConfigurationLocation = null;
        authenticationConfigurationLocation = context.getInitParameter("authenticationConfigurationLocation") != null ? ContextUtil.getContextPath(context, context.getInitParameter("authenticationConfigurationLocation")) : ContextUtil.getContextPath(context, "/WEB-INF/conf/jGuard/jGuardAuthentication.xml");
        return authenticationConfigurationLocation;
    }
}

