/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authorization.http;

import java.io.IOException;
import java.security.Permission;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.filters.FilterChain;
import net.sf.jguard.jee.HttpPermissionFactory;
import net.sf.jguard.jee.PermissionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletAuthorizationBindings
implements AuthorizationBindings {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpServletAuthorizationBindings.class.getName());
    private PermissionFactory permissionFactory = new HttpPermissionFactory();

    public Permission getPermissionRequested(AccessContext context) {
        return this.permissionFactory.getPermission(context);
    }

    public void setLastAccessDeniedPermission(AccessContext context, Permission permission) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpSession session = request.getSession(true);
        session.setAttribute("lastAccessDeniedPermission", (Object)permission);
    }

    public void accessDenied(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        if (logger.isDebugEnabled()) {
            logger.debug(" access denied to " + request.getRequestURI());
        }
        logger.debug(" access is denied to " + request.getRequestURI() + " accessDeniedURI is not defined  jGuard send 401 http code ");
        response.setStatus(401);
        try {
            if (!response.isCommitted()) {
                response.sendError(401, "access is denied to " + request.getRequestURI());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void doFilter(AccessContext context, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        javax.servlet.FilterChain filterChain = (javax.servlet.FilterChain)context.getAttribute("filterChain");
        if (logger.isDebugEnabled()) {
            logger.debug("doFilter() -  access authorized to " + request.getRequestURI());
        }
        if (response.isCommitted()) {
            logger.info(" response is commited ");
            return;
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void sendThrowable(AccessContext context, Throwable t) {
        logger.error(t.getMessage(), t);
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        try {
            response.sendError(500);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

