/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authorization.http;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authorization.policy.AccessControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAccessControllerUtils {
    public static final Logger logger = LoggerFactory.getLogger(HttpAccessControllerUtils.class);

    public static AccessControllerUtils getAuthorizationUtils(HttpSession session) {
        AccessControllerUtils authUtils = (AccessControllerUtils)session.getServletContext().getAttribute("accessControllerUtils");
        return authUtils;
    }

    public static void checkPermission(HttpSession session, Permission p) throws AccessControlException, PrivilegedActionException {
        Subject subject;
        if (session == null) {
            throw new AccessControlException(" user is not yet authenticated ", p);
        }
        AuthenticationUtils authNutils = (AuthenticationUtils)session.getAttribute("authenticationUtils");
        if (authNutils != null) {
            subject = authNutils.getSubject();
            if (subject == null) {
                throw new AccessControlException(" user is not yet authenticated ", p);
            }
        } else {
            session.removeAttribute("authenticationUtils");
            throw new AccessControlException(" user is not yet authenticated ", p);
        }
        AccessControllerUtils.checkPermission((Subject)subject, (Permission)p);
    }

    public static boolean hasPermission(HttpServletRequest request, Permission p) {
        boolean result = true;
        try {
            HttpAccessControllerUtils.checkPermission(request.getSession(true), p);
        }
        catch (AccessControlException ace) {
            logger.debug(ace.getMessage());
            result = false;
        }
        catch (PrivilegedActionException pae) {
            logger.debug(pae.getMessage());
            result = false;
        }
        return result;
    }
}

