/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.schemes;

import java.io.IOException;
import java.security.Permission;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.bindings.AuthenticationBindingsFactory;
import net.sf.jguard.core.authentication.bindings.StatefulAuthenticationBindings;
import net.sf.jguard.core.authentication.schemes.FormSchemeHandler;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import net.sf.jguard.core.authorization.policy.AccessControllerUtils;
import net.sf.jguard.jee.HttpPermissionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletFormSchemeHandler
extends FormSchemeHandler {
    private String logonURI;
    private String logoffURI;
    private String logonProcessURI;
    private String loginField;
    private String passwordField;
    private String authenticationSucceedURI;
    private String authenticationFailedURI;
    private static final Logger logger = LoggerFactory.getLogger((String)HttpServletFormSchemeHandler.class.getName());
    private URLPermission authenticationSucceedPermission;
    private URLPermission authenticationFailedPermission;

    public HttpServletFormSchemeHandler(Map<String, String> parameters, AuthenticationBindingsFactory factory) {
        super(parameters, factory);
        this.initSettings(parameters);
    }

    public void buildChallenge(AccessContext context) throws AuthenticationException {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        if (!response.isCommitted()) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.logonURI));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new AuthenticationException((Throwable)ex);
            }
        }
    }

    public void authenticationSucceed(AccessContext context) throws AuthenticationException {
        StatefulAuthenticationBindings authenticationBindings = (StatefulAuthenticationBindings)this.factory.getAuthenticationBindings(context);
        context.setAttribute("redirect", (Object)"true");
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        String redirectURI = this.authenticationSucceedURI;
        URLPermission lastAccessDeniedPermission = (URLPermission)authenticationBindings.getSessionAttribute("lastAccessDeniedPermission");
        String lastAccessDeniedURI = lastAccessDeniedPermission == null ? this.authenticationSucceedURI : lastAccessDeniedPermission.getURI();
        AuthenticationUtils authenticationUtils = authenticationBindings.getAuthenticationUtils();
        if (lastAccessDeniedURI != null && !"".equals(lastAccessDeniedURI)) {
            if (this.goToLastAccessDeniedUriOnSuccess) {
                redirectURI = lastAccessDeniedURI;
            } else if (!AccessControllerUtils.hasPermission((Subject)authenticationUtils.getSubject(), (Permission)this.authenticationSucceedPermission)) {
                redirectURI = this.logonURI;
            }
        }
        logger.debug(" user is authenticated ", (Object)(" redirect to " + redirectURI));
        if (!response.isCommitted()) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + redirectURI));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new AuthenticationException((Throwable)ex);
            }
        }
    }

    public void authenticationFailed(AccessContext context) throws AuthenticationException {
        context.setAttribute("redirect", (Object)"true");
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        HttpServletResponse response = (HttpServletResponse)context.getAttribute("servletResponse");
        if (response.isCommitted()) {
            logger.warn(" response is already committed ");
            return;
        }
        if (this.authenticationFailedPermission != null && !this.authenticationFailedPermission.getURI().equals("")) {
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.authenticationFailedPermission.getURI()));
                logger.debug("authentication failed redirect to " + this.authenticationFailedPermission.getURI());
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new AuthenticationException((Throwable)ex);
            }
            logger.debug(" user is not authenticated  and redirected to " + request.getContextPath() + this.authenticationFailedPermission.getURI());
        }
    }

    protected String getLogin(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        String login = request.getParameter(this.loginField);
        return login;
    }

    protected String getPassword(AccessContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
        String pwd = request.getParameter(this.passwordField);
        return pwd;
    }

    protected Permission getlogonProcessPermission() {
        return this.logonProcessPermission;
    }

    public Permission getLogoffPermission() {
        return this.logoffPermission;
    }

    public Permission getLogonPermission() {
        return this.logonPermission;
    }

    protected Permission getPermission(AccessContext context) {
        return new HttpPermissionFactory().getPermission(context);
    }

    protected void initSettings(Map<String, String> parameters) throws IllegalArgumentException {
        this.logonProcessURI = parameters.get("logonProcessURI");
        this.loginField = parameters.get("loginField");
        this.passwordField = parameters.get("passwordField");
        this.authenticationSucceedURI = parameters.get("authenticationSucceedURI");
        if (this.authenticationSucceedURI == null && "".equals(this.authenticationSucceedURI)) {
            throw new IllegalArgumentException("authenticationSucceedURI parameter is null but is required to instantiate HttpServletFormSchemeHandler");
        }
        this.authenticationSucceedPermission = new URLPermission("authenticationSucceedURI", this.authenticationSucceedURI);
        this.authenticationFailedURI = parameters.get("authenticationFailedURI");
        if (this.authenticationFailedURI == null || "".equals(this.authenticationFailedURI)) {
            throw new IllegalArgumentException("authenticationFailedURI parameter is null but is required to instantiate HttpServletFormSchemeHandler");
        }
        this.authenticationFailedPermission = new URLPermission("authenticationFailedURI", this.authenticationFailedURI);
        this.logonURI = parameters.get("logonURI");
        this.logonPermission = new URLPermission("logonURI", this.logonURI);
        this.logoffURI = parameters.get("logoffURI");
        this.logoffPermission = new URLPermission("logoffURI", this.logoffURI);
        this.logonProcessURI = parameters.get("logonProcessURI");
        this.logonProcessPermission = new URLPermission("logonProcessURI", this.logonProcessURI);
    }
}

