/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.core.principals.UserPrincipal;
import net.sf.jguard.ext.util.SubjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEERequestWrapperUtil {
    private static Logger logger = LoggerFactory.getLogger(JEERequestWrapperUtil.class);

    public static String getRemoteUser(AuthenticationUtils authUtils, AuthenticationManager authManager) {
        String remoteUser = null;
        Subject subject = authUtils.getSubject();
        if (subject == null) {
            return remoteUser;
        }
        JGuardCredential identityCred = SubjectUtils.getIdentityCredential((Subject)subject, (AuthenticationManager)authManager);
        Object value = identityCred.getValue();
        if (value != null) {
            remoteUser = value.toString();
        }
        return remoteUser;
    }

    public static boolean isUserInRole(String applicationName, String role, AuthenticationUtils authUtils) {
        if (applicationName == null || "".equals(applicationName)) {
            logger.error("applicationName is null or empty = " + applicationName);
        }
        if (role == null || "".equals(role)) {
            logger.error("role is null or empty = " + role);
        }
        String composedRoleName = new StringBuffer(applicationName).append('#').append(role).toString();
        Subject subject = authUtils.getSubject();
        Set<RolePrincipal> principals = subject.getPrincipals(RolePrincipal.class);
        for (Principal principal : principals) {
            if (!composedRoleName.equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    public static Principal getUserPrincipal(AuthenticationUtils authUtils) {
        if (authUtils == null) {
            return null;
        }
        Subject subject = authUtils.getSubject();
        return new UserPrincipal(subject);
    }
}

