/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import javax.security.auth.callback.CallbackHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.bindings.AbstractAuthenticationBindings;
import net.sf.jguard.core.authentication.bindings.AuthenticationBindings;
import net.sf.jguard.core.authentication.bindings.AuthenticationBindingsFactory;
import net.sf.jguard.core.authentication.bindings.StatefulAuthenticationBindings;
import net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler;
import net.sf.jguard.jee.authentication.http.JGuardServletRequestWrapper;

public class HttpServletAuthenticationBindings
extends AbstractAuthenticationBindings
implements StatefulAuthenticationBindings {
    public HttpServletAuthenticationBindings(AuthenticationBindingsFactory factory, String authenticationScope, AccessContext accessContext) {
        super(factory, authenticationScope, accessContext);
    }

    public CallbackHandler getCallbackHandler() {
        HttpServletCallbackHandler cbh = new HttpServletCallbackHandler((AuthenticationBindings)this, this.context, this.factory.getAuthenticationSchemeHandlers());
        return cbh;
    }

    public void process() {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        this.context.setAttribute("servletRequest", (Object)new JGuardServletRequestWrapper(request));
    }

    public Object getSessionAttribute(String key) {
        HttpSession session = this.getSession(true);
        return session.getAttribute(key);
    }

    public void setSessionAttribute(String key, Object value) {
        HttpSession session = this.getSession(true);
        session.setAttribute(key, value);
    }

    public void removeSessionAttribute(String key) {
        HttpSession session = this.getSession(true);
        session.removeAttribute(key);
    }

    public void removeApplicationAttribute(String key) {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        ServletContext servletContext = request.getSession(true).getServletContext();
        servletContext.removeAttribute(key);
    }

    public void removeRequestAttribute(String key) {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        request.removeAttribute(key);
    }

    public void setRequestAttribute(String key, Object value) {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        request.setAttribute(key, value);
    }

    public void setApplicationAttribute(String key, Object value) {
        ServletContext servletContext = this.getServletContext();
        if (servletContext == null) {
            throw new IllegalStateException(" servletContext is null");
        }
        servletContext.setAttribute(key, value);
    }

    public Object getRequestAttribute(String key) {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        return request.getAttribute(key);
    }

    public Object getApplicationAttribute(String key) {
        ServletContext servletContext = this.getServletContext();
        if (servletContext == null) {
            return null;
        }
        return servletContext.getAttribute(key);
    }

    public void invalidateSession() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    private ServletContext getServletContext() {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        ServletContext servletContext = request != null ? request.getSession(true).getServletContext() : (ServletContext)this.context.getAttribute("servletContext");
        return servletContext;
    }

    private HttpSession getSession(boolean createSession) {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        HttpSession session = request.getSession(createSession);
        return session;
    }

    public String getInitApplicationAttribute(String key) {
        return this.getServletContext().getInitParameter(key);
    }
}

