/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import com.octo.captcha.module.config.CaptchaModuleConfig;
import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.EhcacheManageableCaptchaService;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaChallengeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CaptchaChallengeBuilder.class);

    public static void buildCaptchaChallenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        CaptchaService service = (CaptchaService)session.getServletContext().getAttribute("captchaService");
        if (service == null) {
            logger.debug("captcha service should be defined ");
            try {
                service = (CaptchaService)Thread.currentThread().getContextClassLoader().loadClass(CaptchaModuleConfig.getInstance().getServiceClass()).newInstance();
                session.getServletContext().setAttribute("captchaService", (Object)service);
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
            }
            logger.debug(" CAPTCHA SERVICE=" + service.getClass().getName() + " will be defined");
            if (service.getClass().isAssignableFrom(EhcacheManageableCaptchaService.class)) {
                ((EhcacheManageableCaptchaService)service).emptyCaptchaStore();
            }
        } else {
            logger.debug(" CAPTCHA SERVICE=" + service.getClass().getName());
        }
        byte[] captchaChallengeAsJpeg = CaptchaChallengeBuilder.buildCaptchaChallenge(session.getId(), request.getLocale(), service);
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        try {
            ServletOutputStream responseOutputStream = response.getOutputStream();
            responseOutputStream.write(captchaChallengeAsJpeg);
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (IOException e) {
            logger.error(" captcha cannot be generated", (Throwable)e);
        }
    }

    private static byte[] buildCaptchaChallenge(String captchaId, Locale locale, CaptchaService service) throws IOException {
        byte[] captchaChallengeAsJpeg = null;
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        logger.debug("sessionID=" + captchaId);
        BufferedImage challenge = (BufferedImage)service.getChallengeForID(captchaId, locale);
        logger.debug("challenge=" + service.getQuestionForID(captchaId, locale));
        logger.debug(" service=" + service);
        JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)jpegOutputStream);
        jpegEncoder.encode(challenge);
        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        return captchaChallengeAsJpeg;
    }
}

