/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AuthSchemesHelper {
    public static String getCurrentAuthScheme(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String currentAuthScheme = (String)session.getAttribute("currentAuthScheme");
        if (currentAuthScheme == null) {
            List authSchemes = (List)session.getAttribute("authScheme");
            currentAuthScheme = (String)authSchemes.get(0);
            session.setAttribute("currentAuthScheme", (Object)currentAuthScheme);
        }
        return currentAuthScheme;
    }

    public static boolean advanceToNextScheme(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        List authSchemes = (List)session.getAttribute("authScheme");
        String oldCurrentScheme = AuthSchemesHelper.getCurrentAuthScheme(request);
        int oldCurrentSchemeIndex = authSchemes.indexOf(oldCurrentScheme);
        if (authSchemes.size() <= oldCurrentSchemeIndex + 1) {
            return false;
        }
        String currentAuthScheme = (String)authSchemes.get(oldCurrentSchemeIndex + 1);
        session.setAttribute("currentAuthScheme", (Object)currentAuthScheme);
        return true;
    }

    public static Collection validateAuthScheme(String authSchemes) {
        List<Object> authSchemesList = null;
        if (authSchemes == null) {
            authSchemes = "FORM";
            authSchemesList = new ArrayList<String>();
            authSchemesList.add(authSchemes);
            return authSchemesList;
        }
        String[] schemes = authSchemes.split(",");
        authSchemesList = Arrays.asList(schemes);
        for (String string : authSchemesList) {
            if (!("FORM".equalsIgnoreCase(string) || "BASIC".equalsIgnoreCase(string) || "DIGEST".equalsIgnoreCase(string) || "CLIENT-CERT".equalsIgnoreCase(string))) {
                throw new IllegalArgumentException(" each authentication scheme should be 'BASIC','FORM','DIGEST',or 'CLIENT-CERT' and not '" + authSchemes + "' ");
            }
            String string2 = string.toUpperCase();
        }
        return authSchemesList;
    }
}

