/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.Policy;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.PolicyEnforcementPoint;
import net.sf.jguard.core.PolicyEnforcementPointOptions;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.bindings.AuthenticationBindingsFactory;
import net.sf.jguard.jee.authentication.http.HttpServletAuthenticationBindingsFactory;
import net.sf.jguard.jee.authorization.http.HttpServletAuthorizationBindings;
import net.sf.jguard.jee.provisioning.HttpServletProvisioningServicePoint;
import net.sf.jguard.jee.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AccessFilter.class);
    public static final String SERVLET_REQUEST = "servletRequest";
    public static final String SERVLET_RESPONSE = "servletResponse";
    public static final String FILTER_CHAIN = "filterChain";
    public static final String SERVLET_CONTEXT = "servletContext";
    private static String applicationName;
    private PolicyEnforcementPoint pep = null;
    private AuthenticationBindingsFactory authBindingsFactory;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("server info = " + filterConfig.getServletContext().getServerInfo());
        logger.debug("servletContextName=" + filterConfig.getServletContext().getServletContextName());
        logger.debug("servlet Real Path=" + ContextUtil.getContextPath(filterConfig.getServletContext(), "/"));
        logger.debug("current Policy=" + Policy.getPolicy());
        ServletContext context = filterConfig.getServletContext();
        applicationName = context.getServletContextName();
        if (applicationName == null) {
            logger.error(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
            throw new ServletException(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
        }
        HashMap<PolicyEnforcementPointOptions, String> options = new HashMap<PolicyEnforcementPointOptions, String>();
        String authenticationBindingsFactoryImpl = context.getInitParameter(PolicyEnforcementPointOptions.AUTHENTICATION_BINDINGS_FACTORY.getLabel());
        if (authenticationBindingsFactoryImpl == null || authenticationBindingsFactoryImpl.equals("")) {
            authenticationBindingsFactoryImpl = HttpServletAuthenticationBindingsFactory.class.getName();
        }
        options.put(PolicyEnforcementPointOptions.AUTHENTICATION_BINDINGS_FACTORY, authenticationBindingsFactoryImpl);
        String filterConfigurationLocation = ContextUtil.getContextPath(context, filterConfig.getInitParameter(PolicyEnforcementPointOptions.CONFIGURATION_LOCATION.getLabel()));
        options.put(PolicyEnforcementPointOptions.CONFIGURATION_LOCATION, filterConfigurationLocation);
        String authenticationScope = context.getInitParameter(PolicyEnforcementPointOptions.AUTHENTICATION_SCOPE.getLabel());
        if (authenticationScope == null || "".equals(authenticationScope)) {
            authenticationScope = "local";
        }
        options.put(PolicyEnforcementPointOptions.AUTHENTICATION_SCOPE, authenticationScope);
        String authorizationBindingsImpl = context.getInitParameter(PolicyEnforcementPointOptions.AUTHORIZATION_BINDINGS.getLabel());
        if (authorizationBindingsImpl == null || authorizationBindingsImpl.equals("")) {
            authorizationBindingsImpl = HttpServletAuthorizationBindings.class.getName();
        }
        options.put(PolicyEnforcementPointOptions.AUTHORIZATION_BINDINGS, authorizationBindingsImpl);
        String provisioningServicePointImpl = context.getInitParameter(PolicyEnforcementPointOptions.PROVISIONING_SERVICE_POINT.getLabel());
        if (provisioningServicePointImpl == null || provisioningServicePointImpl.equals("")) {
            provisioningServicePointImpl = HttpServletProvisioningServicePoint.class.getName();
        }
        options.put(PolicyEnforcementPointOptions.PROVISIONING_SERVICE_POINT, provisioningServicePointImpl);
        boolean propagateThrowableOption = false;
        String propagateThrowable = context.getInitParameter(PolicyEnforcementPointOptions.PROPAGATE_THROWABLE.getLabel());
        if (propagateThrowable != null && !"".equals(propagateThrowable)) {
            propagateThrowableOption = Boolean.parseBoolean(propagateThrowable);
        }
        options.put(PolicyEnforcementPointOptions.PROPAGATE_THROWABLE, Boolean.toString(propagateThrowableOption));
        options.put(PolicyEnforcementPointOptions.APPLICATION_NAME, applicationName);
        this.pep = new PolicyEnforcementPoint(authenticationBindingsFactoryImpl, options);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AccessContext context = new AccessContext();
        context.setAttribute(SERVLET_REQUEST, (Object)servletRequest);
        context.setAttribute(SERVLET_RESPONSE, (Object)servletResponse);
        context.setAttribute(FILTER_CHAIN, (Object)filterChain);
        try {
            this.pep.process(context);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.sendError(500);
        }
    }

    public void destroy() {
    }
}

