/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.jee.authentication.callbacks;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.bindings.AuthenticationBindings;
import net.sf.jguard.core.authentication.callbacks.AbstractCallbackHandler;
import net.sf.jguard.core.authentication.callbacks.InetAddressCallback;
import net.sf.jguard.core.authentication.schemes.AuthenticationSchemeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletCallbackHandler
extends AbstractCallbackHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletCallbackHandler.class);

    public HttpServletCallbackHandler(AuthenticationBindings authBindings, AccessContext context, List<AuthenticationSchemeHandler> authenticationSchemeHandlers) {
        super(authBindings, context, authenticationSchemeHandlers);
    }

    protected void handleNonSchemeCallbacks(List<Callback> cbks) throws UnsupportedCallbackException {
        HttpServletRequest request = (HttpServletRequest)this.context.getAttribute("servletRequest");
        for (Callback cb : cbks) {
            if (cb instanceof InetAddressCallback) {
                String remoteAddress = request.getRemoteAddr();
                String remoteHost = request.getRemoteHost();
                InetAddressCallback inetAddressCallback = (InetAddressCallback)cb;
                inetAddressCallback.setHostAdress(remoteAddress);
                if (!remoteAddress.equals(remoteHost)) continue;
                String resolvedHostName = remoteAddress;
                try {
                    resolvedHostName = HttpServletCallbackHandler.reverseDns(remoteAddress);
                }
                catch (UnknownHostException uhe) {
                    logger.warn(" host bound to address " + remoteAddress + "cannot be resolved", (Throwable)uhe);
                    throw new UnsupportedCallbackException(cb, uhe.getMessage());
                }
                catch (IOException ex) {
                    logger.equals(ex.getMessage());
                    throw new UnsupportedCallbackException(cb, ex.getMessage());
                }
                inetAddressCallback.setHostName(resolvedHostName);
                continue;
            }
            if (!(cb instanceof LanguageCallback)) continue;
            LanguageCallback languageCallback = (LanguageCallback)cb;
            Locale locale = request.getLocale();
            languageCallback.setLocale(locale);
        }
    }

    public static String reverseDns(String hostIp) throws IOException {
        int dclass;
        int type;
        ExtendedResolver res = new ExtendedResolver();
        Name name = ReverseMap.fromAddress((String)hostIp);
        Record rec = Record.newRecord((Name)name, (int)(type = 12), (int)(dclass = 1));
        Message query = Message.newQuery((Record)rec);
        Message response = res.send(query);
        Record[] answers = response.getSectionArray(1);
        if (answers.length == 0) {
            return hostIp;
        }
        return answers[0].rdataToString();
    }

    protected boolean isAsynchronous() {
        return true;
    }
}

