/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.jee.authentication.http;


import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.bindings.AuthenticationBindingsFactory;
import net.sf.jguard.core.authentication.bindings.StatefulAuthenticationBindings;
import net.sf.jguard.core.authentication.schemes.AuthenticationSchemeHandler;
import net.sf.jguard.jee.authentication.callbacks.HttpServletCallbackHandler;
import net.sf.jguard.core.authentication.bindings.AbstractAuthenticationBindings;


/**
 *
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class HttpServletAuthenticationBindings extends AbstractAuthenticationBindings implements StatefulAuthenticationBindings{
    
    
    
    /**
     * Creates a new instance of HttpServletAuthenticationBindings
     */
    public HttpServletAuthenticationBindings(AuthenticationBindingsFactory factory,String authenticationScope,AccessContext accessContext) {
    	super(factory,authenticationScope,accessContext);
    }


 
    public CallbackHandler getCallbackHandler() {
            HttpServletCallbackHandler cbh = new HttpServletCallbackHandler(this,context,(List<AuthenticationSchemeHandler>) factory.getAuthenticationSchemeHandlers());
            return cbh;
    }


    /**
     * decorate the HttpServletRequest with a {@link JGuardServletRequestWrapper}.
     */
    public void process() {
    	HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
        context.setAttribute(AccessFilter.SERVLET_REQUEST, new JGuardServletRequestWrapper(request));
    }


        
	public Object getSessionAttribute(String key) {
                HttpSession session = getSession(true);
		return session.getAttribute(key);
	}

	public void setSessionAttribute(String key, Object value) {
                HttpSession session = getSession(true);
                session.setAttribute(key, value);
	}

	public void removeSessionAttribute(String key) {
		HttpSession session = getSession(true);
		session.removeAttribute(key);
	}
	
	public void removeApplicationAttribute(String key) {
		HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
		ServletContext servletContext = request.getSession(true).getServletContext();
		servletContext.removeAttribute(key);
	}
	
	public void removeRequestAttribute(String key) {
		HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
		request.removeAttribute(key);
	}

	public void setRequestAttribute(String key,Object value) {
		HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
		request.setAttribute(key, value);
	}

	public void setApplicationAttribute(String key,Object value) {
		ServletContext servletContext = getServletContext();
        if(servletContext==null){
            throw new IllegalStateException(" servletContext is null");
        }
		servletContext.setAttribute(key, value);
	}

	public Object getRequestAttribute(String key) {
		HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
		return request.getAttribute(key);
	}

	public Object getApplicationAttribute(String key) {
        ServletContext servletContext = getServletContext();
        if(servletContext==null){
            return null;
        }
		return servletContext.getAttribute(key);
	}


	public void invalidateSession() {
		HttpSession session = getSession(false);
		if(session!=null){
			session.invalidate();
		}
	}

    private ServletContext getServletContext() {
        HttpServletRequest request = (HttpServletRequest)context.getAttribute(AccessFilter.SERVLET_REQUEST);
        ServletContext servletContext;
        if (request != null) {
            servletContext = request.getSession(true).getServletContext();
        } else {
            servletContext = (ServletContext) context.getAttribute(AccessFilter.SERVLET_CONTEXT);
        }
        return servletContext;
    }

    private HttpSession getSession(boolean createSession) {
        HttpServletRequest request = (HttpServletRequest) context.getAttribute(AccessFilter.SERVLET_REQUEST);
        HttpSession session = request.getSession(createSession);
        return session;
    }

    public String getInitApplicationAttribute(String key) {
        return getServletContext().getInitParameter(key);
    }

}
