/*
	jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.jee.authentication.http;

import java.io.IOException;
import java.security.Policy;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.CoreConstants;
import net.sf.jguard.core.PolicyEnforcementPoint;
import net.sf.jguard.core.PolicyEnforcementPointOptions;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.bindings.AuthenticationBindingsFactory;
import net.sf.jguard.jee.authorization.http.HttpServletAuthorizationBindings;
import net.sf.jguard.jee.provisioning.HttpServletProvisioningServicePoint;
import net.sf.jguard.jee.util.ContextUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Bound HTTP call (contained into AccessContext) to AuthenticationLifeCycle via 
 * via AuthenticationBindings.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class AccessFilter implements Filter{
    private static final Logger logger = LoggerFactory.getLogger(AccessFilter.class);
    public final static String SERVLET_REQUEST="servletRequest";
    public final static String SERVLET_RESPONSE="servletResponse";
    public final static String FILTER_CHAIN="filterChain";
    public final static String SERVLET_CONTEXT="servletContext";
    
    //unique name of the application
    private static String applicationName;
    
    private PolicyEnforcementPoint pep = null; 
    private AuthenticationBindingsFactory authBindingsFactory;
    
    /**
     * Creates a new instance of HttpServletAuthenticationFilter
     */
    public AccessFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("server info = "+filterConfig.getServletContext().getServerInfo());
    	logger.debug("servletContextName="+ filterConfig.getServletContext().getServletContextName());
    	logger.debug("servlet Real Path="+ ContextUtil.getContextPath(filterConfig.getServletContext(),"/"));
    	logger.debug("current Policy="+Policy.getPolicy());
        ServletContext context = filterConfig.getServletContext();
    	applicationName = context.getServletContextName();
    	if(applicationName == null){
    		logger.error(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
    		throw new ServletException(" ServletContext.getServletContextName() return null \n you should fix your web.xml by adding the 'display-name' markup with the name of your webapp ");
    	}
    	
    	Map<PolicyEnforcementPointOptions,String> options = new HashMap<PolicyEnforcementPointOptions,String>();
    	
    	String authenticationBindingsFactoryImpl = context.getInitParameter(PolicyEnforcementPointOptions.AUTHENTICATION_BINDINGS_FACTORY.getLabel());
        if(authenticationBindingsFactoryImpl == null ||authenticationBindingsFactoryImpl.equals("")){
                authenticationBindingsFactoryImpl = HttpServletAuthenticationBindingsFactory.class.getName();
        }
        options.put(PolicyEnforcementPointOptions.AUTHENTICATION_BINDINGS_FACTORY,authenticationBindingsFactoryImpl);

        String filterConfigurationLocation = ContextUtil.getContextPath(context,filterConfig.getInitParameter(PolicyEnforcementPointOptions.CONFIGURATION_LOCATION.getLabel()));
        options.put(PolicyEnforcementPointOptions.CONFIGURATION_LOCATION,filterConfigurationLocation);

        String authenticationScope = (String)context.getInitParameter(PolicyEnforcementPointOptions.AUTHENTICATION_SCOPE.getLabel());
        if(authenticationScope==null || "".equals(authenticationScope)){
                authenticationScope = CoreConstants.LOCAL_SCOPE;
        }
        options.put(PolicyEnforcementPointOptions.AUTHENTICATION_SCOPE,authenticationScope);
    	
    	//PolicyDecisionPoint init parameters
    	String authorizationBindingsImpl = context.getInitParameter(PolicyEnforcementPointOptions.AUTHORIZATION_BINDINGS.getLabel());
        if(authorizationBindingsImpl == null ||authorizationBindingsImpl.equals("")){
                authorizationBindingsImpl = HttpServletAuthorizationBindings.class.getName();
        }
        options.put(PolicyEnforcementPointOptions.AUTHORIZATION_BINDINGS,authorizationBindingsImpl);
		
		
        String provisioningServicePointImpl = context.getInitParameter(PolicyEnforcementPointOptions.PROVISIONING_SERVICE_POINT.getLabel());
        if(provisioningServicePointImpl == null ||provisioningServicePointImpl.equals("")){
                provisioningServicePointImpl = HttpServletProvisioningServicePoint.class.getName();
        }
        options.put(PolicyEnforcementPointOptions.PROVISIONING_SERVICE_POINT,provisioningServicePointImpl);

        boolean propagateThrowableOption = false;
        String propagateThrowable = context.getInitParameter(PolicyEnforcementPointOptions.PROPAGATE_THROWABLE.getLabel());
        if(propagateThrowable != null &&!("").equals(propagateThrowable)){
                propagateThrowableOption = Boolean.parseBoolean(propagateThrowable);
        }
        options.put(PolicyEnforcementPointOptions.PROPAGATE_THROWABLE,Boolean.toString(propagateThrowableOption));

        options.put(PolicyEnforcementPointOptions.APPLICATION_NAME, applicationName);
        pep = new PolicyEnforcementPoint(authenticationBindingsFactoryImpl,options);
    }

	

	
	
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AccessContext context = new AccessContext();
        context.setAttribute(SERVLET_REQUEST,servletRequest);
        context.setAttribute(SERVLET_RESPONSE,servletResponse);
        context.setAttribute(FILTER_CHAIN,filterChain);
        
        try{
            pep.process(context);
        }catch(Throwable t){
            logger.error(t.getMessage(),t);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.sendError(response.SC_INTERNAL_SERVER_ERROR);
        }
       
    }

    public void destroy() {
    }
    
}
