/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.jee.authentication.callbacks;

import java.lang.reflect.Constructor;
import java.net.URL;
import junit.framework.TestCase;
import net.sf.jguard.core.authentication.bindings.AbstractAuthenticationBindingsFactory;

/**
 *
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public abstract class AbstractAuthenticationBindingsFactoryTest extends TestCase{

    public void loadConfiguration(Class<? extends AbstractAuthenticationBindingsFactory> clazz,String scope){
        URL url = Thread.currentThread().getContextClassLoader().getResource("jGuardFilter.xml");
        String location = url.toString();
		System.out.println(location);
        
		try {
            Constructor<? extends AbstractAuthenticationBindingsFactory> c =  clazz.getConstructor(String.class);
            AbstractAuthenticationBindingsFactory factory = c.newInstance(scope);
            factory.init(location);
	    }catch(Throwable e){
	    	System.out.println(e);
	    	e.printStackTrace();
            TestCase.fail(" testLoadConfiguration fail ");
        }
    }
    public abstract void testLoadConfiguration();
}
